/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.streams;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.streams.Pipe;
import io.vertx.core.streams.StreamBase;
import io.vertx.core.streams.WriteStream;
import io.vertx.core.streams.impl.PipeImpl;

@VertxGen(concrete=false)
public interface ReadStream<T>
extends StreamBase {
    @Override
    public ReadStream<T> exceptionHandler(@Nullable Handler<Throwable> var1);

    @Fluent
    public ReadStream<T> handler(@Nullable Handler<T> var1);

    @Fluent
    public ReadStream<T> pause();

    @Fluent
    public ReadStream<T> resume();

    @Fluent
    public ReadStream<T> fetch(long var1);

    @Fluent
    public ReadStream<T> endHandler(@Nullable Handler<Void> var1);

    default public Pipe<T> pipe() {
        this.pause();
        return new PipeImpl(this);
    }

    default public Future<Void> pipeTo(WriteStream<T> dst) {
        Promise<Void> promise = Promise.promise();
        new PipeImpl<T>(this).to(dst, promise);
        return promise.future();
    }

    default public void pipeTo(WriteStream<T> dst, Handler<AsyncResult<Void>> handler) {
        new PipeImpl<T>(this).to(dst, handler);
    }
}

