/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.flink.operation;

import java.util.Optional;
import org.apache.flink.api.common.JobID;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.gateway.api.operation.OperationHandle;
import org.apache.flink.table.gateway.service.result.ResultFetcher;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.command.HelpOperation;
import org.apache.kyuubi.engine.flink.FlinkEngineUtils$;
import org.apache.kyuubi.engine.flink.operation.FlinkOperation;
import org.apache.kyuubi.engine.flink.result.ResultSetUtil$;
import org.apache.kyuubi.operation.OperationState$;
import org.apache.kyuubi.operation.log.OperationLog;
import org.apache.kyuubi.operation.log.OperationLog$;
import org.apache.kyuubi.session.Session;
import org.apache.kyuubi.util.reflect.DynConstructors;
import org.apache.kyuubi.util.reflect.DynFields;
import org.apache.kyuubi.util.reflect.DynMethods;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005-c\u0001B\u000b\u0017\u0001\rB\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\te\u0001\u0011)\u0019!C!g!A\u0011\t\u0001B\u0001B\u0003%A\u0007\u0003\u0005C\u0001\t\u0015\r\u0011\"\u0011D\u0011!A\u0005A!A!\u0002\u0013!\u0005\u0002C%\u0001\u0005\u0003\u0005\u000b\u0011\u0002&\t\u00115\u0003!\u0011!Q\u0001\n9C\u0001\"\u0015\u0001\u0003\u0002\u0003\u0006IA\u0015\u0005\u00065\u0002!\ta\u0017\u0005\bG\u0002\u0011\r\u0011\"\u0003e\u0011\u0019a\u0007\u0001)A\u0005K\"9Q\u000e\u0001a\u0001\n\u0003q\u0007bB>\u0001\u0001\u0004%\t\u0001 \u0005\b\u0003\u000b\u0001\u0001\u0015)\u0003p\u0011\u001d\t9\u0001\u0001C!\u0003\u0013Aq!!\u0004\u0001\t#\ny\u0001C\u0004\u0002\u0012\u0001!\t&a\u0004\t\u000f\u0005M\u0001\u0001\"\u0003\u0002\u0010!9\u0011Q\u0003\u0001\u0005\n\u0005]\u0001bBA\u001e\u0001\u0011%\u0011Q\b\u0002\u0011\u000bb,7-\u001e;f'R\fG/Z7f]RT!a\u0006\r\u0002\u0013=\u0004XM]1uS>t'BA\r\u001b\u0003\u00151G.\u001b8l\u0015\tYB$\u0001\u0004f]\u001eLg.\u001a\u0006\u0003;y\taa[=vk\nL'BA\u0010!\u0003\u0019\t\u0007/Y2iK*\t\u0011%A\u0002pe\u001e\u001c\u0001aE\u0002\u0001I!\u0002\"!\n\u0014\u000e\u0003YI!a\n\f\u0003\u001d\u0019c\u0017N\\6Pa\u0016\u0014\u0018\r^5p]B\u0011\u0011FK\u0007\u00029%\u00111\u0006\b\u0002\b\u0019><w-\u001b8h\u0003\u001d\u0019Xm]:j_:\u0004\"A\f\u0019\u000e\u0003=R!\u0001\f\u000f\n\u0005Ez#aB*fgNLwN\\\u0001\ngR\fG/Z7f]R,\u0012\u0001\u000e\t\u0003kyr!A\u000e\u001f\u0011\u0005]RT\"\u0001\u001d\u000b\u0005e\u0012\u0013A\u0002\u001fs_>$hHC\u0001<\u0003\u0015\u00198-\u00197b\u0013\ti$(\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u007f\u0001\u0013aa\u0015;sS:<'BA\u001f;\u0003)\u0019H/\u0019;f[\u0016tG\u000fI\u0001\u000fg\"|W\u000f\u001c3Sk:\f5/\u001f8d+\u0005!\u0005CA#G\u001b\u0005Q\u0014BA$;\u0005\u001d\u0011un\u001c7fC:\fqb\u001d5pk2$'+\u001e8Bgft7\rI\u0001\rcV,'/\u001f+j[\u0016|W\u000f\u001e\t\u0003\u000b.K!\u0001\u0014\u001e\u0003\t1{gnZ\u0001\u000ee\u0016\u001cX\u000f\u001c;NCb\u0014vn^:\u0011\u0005\u0015{\u0015B\u0001);\u0005\rIe\u000e^\u0001\u0013e\u0016\u001cX\u000f\u001c;GKR\u001c\u0007\u000eV5nK>,H\u000f\u0005\u0002T16\tAK\u0003\u0002V-\u0006AA-\u001e:bi&|gN\u0003\u0002Xu\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005e#&\u0001\u0003#ve\u0006$\u0018n\u001c8\u0002\rqJg.\u001b;?)\u001daVLX0aC\n\u0004\"!\n\u0001\t\u000b1J\u0001\u0019A\u0017\t\u000bIJ\u0001\u0019\u0001\u001b\t\u000b\tK\u0001\u0019\u0001#\t\u000b%K\u0001\u0019\u0001&\t\u000b5K\u0001\u0019\u0001(\t\u000bEK\u0001\u0019\u0001*\u0002\u0019=\u0004XM]1uS>tGj\\4\u0016\u0003\u0015\u0004\"A\u001a6\u000e\u0003\u001dT!\u0001[5\u0002\u00071|wM\u0003\u0002\u00189%\u00111n\u001a\u0002\r\u001fB,'/\u0019;j_:dunZ\u0001\u000e_B,'/\u0019;j_:dun\u001a\u0011\u0002\u000b)|'-\u00133\u0016\u0003=\u00042!\u00129s\u0013\t\t(H\u0001\u0004PaRLwN\u001c\t\u0003gfl\u0011\u0001\u001e\u0006\u0003kZ\faaY8n[>t'BA<y\u0003\r\t\u0007/\u001b\u0006\u00033yI!A\u001f;\u0003\u000b){'-\u0013#\u0002\u0013)|'-\u00133`I\u0015\fHcA?\u0002\u0002A\u0011QI`\u0005\u0003\u007fj\u0012A!\u00168ji\"A\u00111A\u0007\u0002\u0002\u0003\u0007q.A\u0002yIE\naA[8c\u0013\u0012\u0004\u0013aD4fi>\u0003XM]1uS>tGj\\4\u0016\u0005\u0005-\u0001cA#qK\u0006I!-\u001a4pe\u0016\u0014VO\u001c\u000b\u0002{\u0006Y!/\u001e8J]R,'O\\1m\u0003A)\u00070Z2vi\u0016\u001cF/\u0019;f[\u0016tG/\u0001\fqCJ\u001cX-\u0012=uK:$W\rZ*uCR,W.\u001a8u)\u0011\tI\"!\u000f\u0011\r\u0005m\u0011QEA\u0015\u001b\t\tiB\u0003\u0003\u0002 \u0005\u0005\u0012\u0001B;uS2T!!a\t\u0002\t)\fg/Y\u0005\u0005\u0003O\tiB\u0001\u0005PaRLwN\\1m!\u0011\tY#!\u000e\u000e\u0005\u00055\"\u0002BA\u0018\u0003c\t!b\u001c9fe\u0006$\u0018n\u001c8t\u0015\r\t\u0019\u0004_\u0001\u0006i\u0006\u0014G.Z\u0005\u0005\u0003o\tiCA\u0005Pa\u0016\u0014\u0018\r^5p]\")!g\u0005a\u0001i\u0005Yr-\u001a;QY\u0006tg.\u001a:N_\u0012,H.Z\"mCN\u001cHj\\1eKJ,\"!a\u0010\u0011\t\u0005\u0005\u0013qI\u0007\u0003\u0003\u0007RA!!\u0012\u0002\"\u0005!A.\u00198h\u0013\u0011\tI%a\u0011\u0003\u0017\rc\u0017m]:M_\u0006$WM\u001d")
public class ExecuteStatement
extends FlinkOperation {
    private final String statement;
    private final boolean shouldRunAsync;
    private final long queryTimeout;
    private final int resultMaxRows;
    private final Duration resultFetchTimeout;
    private final OperationLog operationLog;
    private Option<JobID> jobId;

    @Override
    public String statement() {
        return this.statement;
    }

    @Override
    public boolean shouldRunAsync() {
        return this.shouldRunAsync;
    }

    private OperationLog operationLog() {
        return this.operationLog;
    }

    public Option<JobID> jobId() {
        return this.jobId;
    }

    public void jobId_$eq(Option<JobID> x$1) {
        this.jobId = x$1;
    }

    @Override
    public Option<OperationLog> getOperationLog() {
        return Option$.MODULE$.apply((Object)this.operationLog());
    }

    @Override
    public void beforeRun() {
        OperationLog$.MODULE$.setCurrentOperationLog(this.operationLog());
        this.setState(OperationState$.MODULE$.PENDING());
        this.setHasResultSet(true);
    }

    @Override
    public void runInternal() {
        this.addTimeoutMonitor(this.queryTimeout);
        this.executeStatement();
    }

    private void executeStatement() {
        block8: {
            block7: {
                try {
                    try {
                        this.setState(OperationState$.MODULE$.RUNNING());
                        Optional<Operation> operation = this.parseExtendedStatement(this.statement());
                        if (operation.isPresent() && operation.get() instanceof HelpOperation) {
                            this.resultSet_$eq(ResultSetUtil$.MODULE$.helpMessageResultSet());
                            this.setState(OperationState$.MODULE$.FINISHED());
                            break block7;
                        }
                        ResultFetcher resultFetcher = this.executor().executeStatement(new OperationHandle(this.getHandle().identifier()), this.statement());
                        this.jobId_$eq(FlinkEngineUtils$.MODULE$.getResultJobId(resultFetcher));
                        this.resultSet_$eq(ResultSetUtil$.MODULE$.fromResultFetcher(resultFetcher, this.resultMaxRows, this.resultFetchTimeout));
                        this.setState(OperationState$.MODULE$.FINISHED());
                        break block8;
                    }
                    catch (Throwable x$1) {
                        PartialFunction<Throwable, BoxedUnit> catchExpr$1 = this.onError(true);
                        if (catchExpr$1.isDefinedAt((Object)x$1)) {
                            catchExpr$1.apply((Object)x$1);
                            break block8;
                        }
                        throw x$1;
                    }
                }
                finally {
                    this.shutdownTimeoutMonitor();
                }
            }
            return;
        }
    }

    private Optional<Operation> parseExtendedStatement(String statement) {
        ClassLoader plannerModuleClassLoader = this.getPlannerModuleClassLoader();
        Object extendedParser = DynConstructors.builder().loader(plannerModuleClassLoader).impl("org.apache.flink.table.planner.parse.ExtendedParser", new Class[0]).build().newInstance(new Object[0]);
        return (Optional)DynMethods.builder("parse").hiddenImpl(extendedParser.getClass(), String.class).buildChecked().invoke(extendedParser, statement);
    }

    private ClassLoader getPlannerModuleClassLoader() {
        ClassLoader classLoader;
        try {
            Object plannerModule = DynMethods.builder("getInstance").hiddenImpl("org.apache.flink.table.planner.loader.PlannerModule", new Class[0]).buildStaticChecked().invoke(new Object[0]);
            classLoader = (ClassLoader)DynFields.builder().hiddenImpl(plannerModule.getClass(), "submoduleClassLoader").build().bind(plannerModule).get();
        }
        catch (Exception e) {
            throw new TableException("Error obtaining Flink planner module ClassLoader. Make sure a flink-table-planner-loader.jar is on the classpath", (Throwable)e);
        }
        return classLoader;
    }

    public ExecuteStatement(Session session, String statement, boolean shouldRunAsync, long queryTimeout, int resultMaxRows, Duration resultFetchTimeout) {
        this.statement = statement;
        this.shouldRunAsync = shouldRunAsync;
        this.queryTimeout = queryTimeout;
        this.resultMaxRows = resultMaxRows;
        this.resultFetchTimeout = resultFetchTimeout;
        super(session);
        this.operationLog = OperationLog$.MODULE$.createOperationLog(session, this.getHandle());
        this.jobId = None$.MODULE$;
    }
}

