/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.jmh;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ByteArrayDataOutput;
import org.apache.lucene.store.ByteBuffersDataInput;
import org.apache.lucene.store.ByteBuffersDataOutput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.util.GroupVIntUtil;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;

@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@State(value=Scope.Benchmark)
@Warmup(iterations=3, time=3)
@Measurement(iterations=5, time=5)
@Fork(value=1, jvmArgsPrepend={"--add-modules=jdk.unsupported"})
public class GroupVIntBenchmark {
    private static final float[] CUMULATIVE_FREQUENCY_BY_BITS_REQUIRED = new float[]{0.0f, 0.01026574f, 0.021453038f, 0.03342156f, 0.046476692f, 0.060890317f, 0.07644147f, 0.093718216f, 0.11424741f, 0.13989712f, 0.17366524f, 0.22071244f, 0.2815692f, 0.3537585f, 0.43655503f, 0.52308f, 0.6104675f, 0.7047371f, 0.78155357f, 0.8671179f, 0.9740598f, 1.0f};
    final int maxSize = 256;
    final long[] docs = new long[256];
    final long[] values = new long[256];
    IndexInput byteBufferGVIntIn;
    IndexInput nioGVIntIn;
    IndexInput byteBufferVIntIn;
    ByteBuffersDataInput byteBuffersGVIntIn;
    ByteArrayDataInput byteArrayVIntIn;
    ByteArrayDataInput byteArrayGVIntIn;
    ByteBuffersDataOutput byteBuffersGVIntOut = new ByteBuffersDataOutput();
    @Param(value={"64"})
    public int size;

    void initArrayInput(long[] docs) throws Exception {
        byte[] gVIntBytes = new byte[2048];
        byte[] vIntBytes = new byte[2048];
        ByteArrayDataOutput vIntOut = new ByteArrayDataOutput(vIntBytes);
        ByteArrayDataOutput out = new ByteArrayDataOutput(gVIntBytes);
        out.writeGroupVInts(docs, docs.length);
        for (long v : docs) {
            vIntOut.writeVInt((int)v);
        }
        this.byteArrayVIntIn = new ByteArrayDataInput(vIntBytes);
        this.byteArrayGVIntIn = new ByteArrayDataInput(gVIntBytes);
    }

    void initNioInput(long[] docs) throws Exception {
        NIOFSDirectory dir = new NIOFSDirectory(Files.createTempDirectory("groupvintdata", new FileAttribute[0]));
        IndexOutput out = dir.createOutput("gvint", IOContext.DEFAULT);
        out.writeGroupVInts(docs, docs.length);
        out.close();
        this.nioGVIntIn = dir.openInput("gvint", IOContext.DEFAULT);
    }

    void initByteBuffersInput(long[] docs) throws Exception {
        ByteBuffersDataOutput buffer = new ByteBuffersDataOutput();
        buffer.writeGroupVInts(docs, docs.length);
        this.byteBuffersGVIntIn = buffer.toDataInput();
    }

    void initByteBufferInput(long[] docs) throws Exception {
        MMapDirectory dir = new MMapDirectory(Files.createTempDirectory("groupvintdata", new FileAttribute[0]));
        IndexOutput vintOut = dir.createOutput("vint", IOContext.DEFAULT);
        IndexOutput gvintOut = dir.createOutput("gvint", IOContext.DEFAULT);
        gvintOut.writeGroupVInts(docs, docs.length);
        for (long v : docs) {
            vintOut.writeVInt((int)v);
        }
        vintOut.close();
        gvintOut.close();
        this.byteBufferGVIntIn = dir.openInput("gvint", IOContext.DEFAULT);
        this.byteBufferVIntIn = dir.openInput("vint", IOContext.DEFAULT);
    }

    private void readGroupVIntsBaseline(DataInput in, long[] dst, int limit) throws IOException {
        int i;
        for (i = 0; i <= limit - 4; i += 4) {
            GroupVIntUtil.readGroupVInt((DataInput)in, (long[])dst, (int)i);
        }
        while (i < limit) {
            dst[i] = in.readVInt();
            ++i;
        }
    }

    @Setup(value=Level.Trial)
    public void init() throws Exception {
        Random r = new Random(0L);
        for (int i = 0; i < 256; ++i) {
            float randomFloat = r.nextFloat();
            int numBits = 1 + Arrays.binarySearch(CUMULATIVE_FREQUENCY_BY_BITS_REQUIRED, randomFloat);
            if (numBits < 0) {
                numBits = -numBits;
            }
            this.docs[i] = r.nextInt(1 << numBits - 1, 1 << numBits);
        }
        this.initByteBufferInput(this.docs);
        this.initArrayInput(this.docs);
        this.initNioInput(this.docs);
        this.initByteBuffersInput(this.docs);
    }

    @Benchmark
    public void benchMMapDirectoryInputs_readVInt(Blackhole bh) throws IOException {
        this.byteBufferVIntIn.seek(0L);
        for (int i = 0; i < this.size; ++i) {
            this.values[i] = this.byteBufferVIntIn.readVInt();
        }
        bh.consume((Object)this.values);
    }

    @Benchmark
    public void benchMMapDirectoryInputs_readGroupVInt(Blackhole bh) throws IOException {
        this.byteBufferGVIntIn.seek(0L);
        GroupVIntUtil.readGroupVInts((DataInput)this.byteBufferGVIntIn, (long[])this.values, (int)this.size);
        bh.consume((Object)this.values);
    }

    @Benchmark
    public void benchMMapDirectoryInputs_readGroupVIntBaseline(Blackhole bh) throws IOException {
        this.byteBufferGVIntIn.seek(0L);
        this.readGroupVIntsBaseline((DataInput)this.byteBufferGVIntIn, this.values, this.size);
        bh.consume((Object)this.values);
    }

    @Benchmark
    public void benchByteArrayDataInput_readVInt(Blackhole bh) {
        this.byteArrayVIntIn.rewind();
        for (int i = 0; i < this.size; ++i) {
            this.values[i] = this.byteArrayVIntIn.readVInt();
        }
        bh.consume((Object)this.values);
    }

    @Benchmark
    public void benchByteArrayDataInput_readGroupVInt(Blackhole bh) throws IOException {
        this.byteArrayGVIntIn.rewind();
        GroupVIntUtil.readGroupVInts((DataInput)this.byteArrayGVIntIn, (long[])this.values, (int)this.size);
        bh.consume((Object)this.values);
    }

    @Benchmark
    public void benchNIOFSDirectoryInputs_readGroupVInt(Blackhole bh) throws IOException {
        this.nioGVIntIn.seek(0L);
        GroupVIntUtil.readGroupVInts((DataInput)this.nioGVIntIn, (long[])this.values, (int)this.size);
        bh.consume((Object)this.values);
    }

    @Benchmark
    public void benchNIOFSDirectoryInputs_readGroupVIntBaseline(Blackhole bh) throws IOException {
        this.nioGVIntIn.seek(0L);
        this.readGroupVIntsBaseline((DataInput)this.nioGVIntIn, this.values, this.size);
        bh.consume((Object)this.values);
    }

    @Benchmark
    public void benchByteBuffersIndexInput_readGroupVInt(Blackhole bh) throws IOException {
        this.byteBuffersGVIntIn.seek(0L);
        GroupVIntUtil.readGroupVInts((DataInput)this.byteBuffersGVIntIn, (long[])this.values, (int)this.size);
        bh.consume((Object)this.values);
    }

    @Benchmark
    public void benchByteBuffersIndexInput_readGroupVIntBaseline(Blackhole bh) throws IOException {
        this.byteBuffersGVIntIn.seek(0L);
        this.readGroupVIntsBaseline((DataInput)this.byteBuffersGVIntIn, this.values, this.size);
        bh.consume((Object)this.values);
    }

    @Benchmark
    public void bench_writeGroupVInt(Blackhole bh) throws IOException {
        this.byteBuffersGVIntOut.reset();
        this.byteBuffersGVIntOut.writeGroupVInts(this.docs, this.size);
    }
}

