/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo;

import java.io.Serializable;
import java.rmi.Remote;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.sql.DataSource;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.jdo.conf.JdoConf;
import org.castor.jdo.engine.AbstractConnectionFactory;
import org.castor.jdo.engine.ConnectionFactory;
import org.castor.jdo.engine.DatabaseRegistry;
import org.castor.transactionmanager.LocalTransactionManager;
import org.castor.util.Messages;
import org.exolab.castor.jdo.DataObjects;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.DatabaseNotFoundException;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.engine.GlobalDatabaseImpl;
import org.exolab.castor.jdo.engine.LocalDatabaseImpl;
import org.exolab.castor.jdo.engine.TxDatabaseMap;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.LockEngine;
import org.exolab.castor.persist.spi.CallbackInterceptor;
import org.exolab.castor.persist.spi.InstanceFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public final class JDOManager
implements DataObjects,
Referenceable,
ObjectFactory,
Serializable {
    private static final long serialVersionUID = -7108469291509131893L;
    public static final int DEFAULT_LOCK_TIMEOUT = 10;
    public static final String DEFAULT_DESCRIPTION = "Castor JDO";
    private static final Log LOG = LogFactory.getLog((Class)JDOManager.class);
    private static Map _jdoInstances = new HashMap();
    private static ClassLoader _classLoader;
    private static EntityResolver _entityResolver;
    private static InputSource _source;
    private InputSource _jdoConfURI;
    private CallbackInterceptor _callbackInterceptor;
    private InstanceFactory _instanceFactory;
    private int _lockTimeout = 10;
    private String _description = "Castor JDO";
    private TxDatabaseMap _txDbPool;
    private boolean _autoStore = false;
    private String _databaseName;

    public static JDOManager createInstance(String databaseName) throws MappingException {
        if (!DatabaseRegistry.hasDatabaseRegistries()) {
            throw new MappingException(Messages.message("jdo.missing.jdo.configuration"));
        }
        if (!DatabaseRegistry.isDatabaseRegistred(databaseName)) {
            throw new MappingException(Messages.format("jdo.missing.database.configuration", databaseName));
        }
        JDOManager jdoInstance = (JDOManager)_jdoInstances.get(databaseName);
        if (jdoInstance == null) {
            jdoInstance = new JDOManager(databaseName);
            jdoInstance.setConfiguration(_source);
            jdoInstance.setEntityResolver(_entityResolver);
            jdoInstance.setClassLoader(_classLoader);
            _jdoInstances.put(databaseName, jdoInstance);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Successfully created JDOManager instance: " + jdoInstance));
            }
        }
        return jdoInstance;
    }

    public static void loadConfiguration(String name, String engine, DataSource datasource, Mapping mapping, TransactionManager txManager) throws MappingException {
        DatabaseRegistry.loadDatabase(name, engine, datasource, mapping, txManager);
        _classLoader = null;
        _entityResolver = null;
        LOG.debug((Object)"Successfully loaded JDOManager form preconfigured datasource");
    }

    public static void loadConfiguration(JdoConf jdoConf, EntityResolver resolver, ClassLoader loader, String baseURI) throws MappingException {
        DatabaseRegistry.loadDatabase(jdoConf, resolver, loader, baseURI);
        _classLoader = loader;
        _entityResolver = resolver;
        LOG.debug((Object)"Successfully loaded JDOManager form in-memory configuration");
    }

    public static void loadConfiguration(JdoConf jdoConf, ClassLoader loader, String baseURI) throws MappingException {
        JDOManager.loadConfiguration(jdoConf, null, loader, baseURI);
    }

    public static void loadConfiguration(JdoConf jdoConf, String baseURI) throws MappingException {
        JDOManager.loadConfiguration(jdoConf, null, null, baseURI);
    }

    public static void loadConfiguration(InputSource source, EntityResolver resolver, ClassLoader loader) throws MappingException {
        DatabaseRegistry.loadDatabase(source, resolver, loader);
        _classLoader = loader;
        _entityResolver = resolver;
        _source = source;
        LOG.debug((Object)"Successfully loaded JDOManager configuration");
    }

    public static void loadConfiguration(String url, ClassLoader loader) throws MappingException {
        JDOManager.loadConfiguration(new InputSource(url), null, loader);
    }

    public static void loadConfiguration(String url) throws MappingException {
        JDOManager.loadConfiguration(new InputSource(url), null, null);
    }

    private JDOManager() {
    }

    private JDOManager(String databaseName) {
        this._databaseName = databaseName;
    }

    private void setClassLoader(ClassLoader classLoader) {
        _classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return _classLoader;
    }

    private void setEntityResolver(EntityResolver entityResolver) {
        _entityResolver = entityResolver;
    }

    public EntityResolver getEntityResolver() {
        return _entityResolver;
    }

    private void setConfiguration(InputSource source) {
        this._jdoConfURI = source;
    }

    public InputSource getConfiguration() {
        return this._jdoConfURI;
    }

    public void setCallbackInterceptor(CallbackInterceptor callback) {
        this._callbackInterceptor = callback;
    }

    public CallbackInterceptor getCallbackInterceptor() {
        return this._callbackInterceptor;
    }

    public void setInstanceFactory(InstanceFactory factory) {
        this._instanceFactory = factory;
    }

    public InstanceFactory getInstanceFactory() {
        return this._instanceFactory;
    }

    public void setLockTimeout(int seconds) {
        this._lockTimeout = seconds;
    }

    public int getLockTimeout() {
        return this._lockTimeout;
    }

    public void setDescription(String description) {
        if (description == null) {
            throw new NullPointerException("Argument 'description' is null");
        }
        this._description = description;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDatabasePooling(boolean pool) {
        if (!pool) {
            if (this._txDbPool == null) {
                return;
            }
            if (this._txDbPool.isEmpty()) {
                this._txDbPool = null;
                return;
            }
            throw new IllegalStateException("JDO Pooling started. It can not be set to false.");
        }
        if (this._txDbPool == null) {
            this._txDbPool = new TxDatabaseMap();
        }
    }

    public boolean getDatabasePooling() {
        return this._txDbPool != null;
    }

    public void setAutoStore(boolean autoStore) {
        this._autoStore = autoStore;
    }

    public boolean isAutoStore() {
        return this._autoStore;
    }

    public String getDatabaseName() {
        return this._databaseName;
    }

    public ConnectionFactory getConnectionFactory() throws MappingException {
        return DatabaseRegistry.getConnectionFactory(this._databaseName);
    }

    public Database getDatabase() throws PersistenceException {
        if (this._databaseName == null) {
            String msg = Messages.message("jdo.missing.database.name");
            LOG.error((Object)msg);
            throw new IllegalStateException(msg);
        }
        TransactionManager transactionManager = null;
        try {
            if (!DatabaseRegistry.isDatabaseRegistred(this._databaseName)) {
                if (this._jdoConfURI == null) {
                    String msg = Messages.format("jdo.dbNoMapping", this._databaseName);
                    LOG.error((Object)msg);
                    throw new DatabaseNotFoundException(msg);
                }
                DatabaseRegistry.loadDatabase(this._jdoConfURI, _entityResolver, _classLoader);
            }
            AbstractConnectionFactory factory = DatabaseRegistry.getConnectionFactory(this._databaseName);
            transactionManager = factory.getTransactionManager();
        }
        catch (MappingException ex) {
            String msg = Messages.format("jdo.problem.loading.conf", this._jdoConfURI);
            LOG.error((Object)msg, (Throwable)ex);
            throw new DatabaseNotFoundException(msg, ex);
        }
        if (transactionManager instanceof LocalTransactionManager) {
            return new LocalDatabaseImpl(this._databaseName, this._lockTimeout, this._callbackInterceptor, this._instanceFactory, _classLoader, this._autoStore);
        }
        Transaction tx = null;
        int status = -1;
        try {
            tx = transactionManager.getTransaction();
            if (tx != null) {
                status = tx.getStatus();
            }
        }
        catch (Exception ex) {
            String msg = Messages.message("jdo.manager.failCreateTransaction");
            LOG.error((Object)msg, (Throwable)ex);
            throw new PersistenceException(msg, ex);
        }
        if (tx == null || status != 0) {
            String msg = Messages.message("jdo.manager.failGetTransaction");
            LOG.error((Object)msg);
            throw new PersistenceException(msg);
        }
        if (this._txDbPool != null && this._txDbPool.containsTx(tx)) {
            return this._txDbPool.get(tx);
        }
        GlobalDatabaseImpl dbImpl = new GlobalDatabaseImpl(this._databaseName, this._lockTimeout, this._callbackInterceptor, this._instanceFactory, tx, _classLoader, this._autoStore, this.getDatabasePooling());
        try {
            tx.registerSynchronization((Synchronization)dbImpl);
        }
        catch (Exception ex) {
            String msg = Messages.message("jdo.manager.failRegisterTransaction");
            LOG.error((Object)msg, (Throwable)ex);
            throw new PersistenceException(msg, ex);
        }
        if (this._txDbPool != null) {
            this._txDbPool.put(tx, dbImpl);
        }
        return dbImpl;
    }

    public synchronized Reference getReference() {
        Reference ref = new Reference(this.getClass().getName(), this.getClass().getName(), null);
        if (this._description != null) {
            ref.add(new StringRefAddr("description", this._description));
        }
        if (this._databaseName != null) {
            ref.add(new StringRefAddr("databaseName", this._databaseName));
        }
        if (this._jdoConfURI != null) {
            ref.add(new StringRefAddr("configuration", this._jdoConfURI.toString()));
        }
        ref.add(new StringRefAddr("lockTimeout", Integer.toString(this._lockTimeout)));
        return ref;
    }

    public Object getObjectInstance(Object refObj, Name name, Context nameCtx, Hashtable env) throws NamingException {
        if (refObj instanceof Reference) {
            JDOManager jdo;
            Reference ref = (Reference)refObj;
            if (!ref.getClassName().equals(this.getClass().getName())) {
                throw new NamingException(Messages.format("jdo.reference.wrong.type", ref.getClassName()));
            }
            try {
                jdo = (JDOManager)Class.forName(ref.getClassName()).newInstance();
            }
            catch (Exception ex) {
                NamingException ne = new NamingException(Messages.format("jdo.problem.loading.class", ref.getClassName()));
                ne.setRootCause(ex);
                throw ne;
            }
            RefAddr addr = ref.get("description");
            if (addr != null) {
                jdo._description = (String)addr.getContent();
            }
            if ((addr = ref.get("databaseName")) != null) {
                jdo._databaseName = (String)addr.getContent();
            }
            if ((addr = ref.get("configuration")) != null) {
                jdo._jdoConfURI = (InputSource)addr.getContent();
            }
            if ((addr = ref.get("lockTimeout")) != null) {
                jdo._lockTimeout = Integer.parseInt((String)addr.getContent());
            }
            return jdo;
        }
        if (refObj instanceof Remote) {
            return refObj;
        }
        return null;
    }

    public void close() {
        try {
            ConnectionFactory factory = this.getConnectionFactory();
            LockEngine engine = ((AbstractConnectionFactory)factory).getEngine();
            engine.closeCaches();
        }
        catch (MappingException e) {
            LOG.fatal((Object)"Problem closing down caches", (Throwable)e);
        }
    }
}

