/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.junit;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.VerificationException;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.verification.NearMiss;
import java.util.List;
import org.junit.rules.MethodRule;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class WireMockRule
extends WireMockServer
implements MethodRule,
TestRule {
    private final boolean failOnUnmatchedStubs;

    public WireMockRule(Options options) {
        this(options, true);
    }

    public WireMockRule(Options options, boolean failOnUnmatchedStubs) {
        super(options);
        this.failOnUnmatchedStubs = failOnUnmatchedStubs;
    }

    public WireMockRule(int port) {
        this(WireMockConfiguration.wireMockConfig().port(port));
    }

    public WireMockRule(int port, Integer httpsPort) {
        this(WireMockConfiguration.wireMockConfig().port(port).httpsPort(httpsPort));
    }

    public WireMockRule() {
        this(WireMockConfiguration.wireMockConfig());
    }

    public Statement apply(Statement base, Description description) {
        return this.apply(base, null, null);
    }

    public Statement apply(final Statement base, FrameworkMethod method, Object target) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                WireMockRule.this.start();
                WireMock.configureFor("localhost", WireMockRule.this.port());
                try {
                    WireMockRule.this.before();
                    base.evaluate();
                    WireMockRule.this.checkForUnmatchedRequests();
                }
                finally {
                    WireMockRule.this.after();
                    WireMockRule.this.stop();
                }
            }
        };
    }

    private void checkForUnmatchedRequests() {
        List<NearMiss> nearMisses;
        if (this.failOnUnmatchedStubs && !(nearMisses = this.findNearMissesForAllUnmatchedRequests()).isEmpty()) {
            throw VerificationException.forUnmatchedRequests(nearMisses);
        }
    }

    protected void before() {
    }

    protected void after() {
    }
}

