/*
 * Decompiled with CFR 0.152.
 */
package jj2000.disp;

import java.awt.Adjustable;
import java.awt.Font;
import java.awt.Frame;
import java.awt.TextArea;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import jj2000.disp.ImgScrollPane;
import jj2000.j2k.decoder.Decoder;

public class ImgKeyListener
extends KeyAdapter {
    Frame helpFrame = null;
    ImgScrollPane isp;
    Decoder dec;
    public static final int ACCEL_FACTOR = 10;

    public ImgKeyListener(ImgScrollPane isp, Decoder dec) {
        this.isp = isp;
        this.dec = dec;
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        if (evt.isConsumed()) {
            return;
        }
        switch (evt.getKeyCode()) {
            case 37: {
                Adjustable adj = this.isp.getHAdjustable();
                adj.setValue(adj.getValue() - this.calcIncrement(evt, adj));
                break;
            }
            case 39: {
                Adjustable adj = this.isp.getHAdjustable();
                adj.setValue(adj.getValue() + this.calcIncrement(evt, adj));
                break;
            }
            case 38: {
                Adjustable adj = this.isp.getVAdjustable();
                adj.setValue(adj.getValue() - this.calcIncrement(evt, adj));
                break;
            }
            case 40: {
                Adjustable adj = this.isp.getVAdjustable();
                adj.setValue(adj.getValue() + this.calcIncrement(evt, adj));
                break;
            }
            case 33: {
                Adjustable adj = this.isp.getVAdjustable();
                adj.setValue(adj.getValue() - adj.getBlockIncrement());
                break;
            }
            case 34: {
                Adjustable adj = this.isp.getVAdjustable();
                adj.setValue(adj.getValue() + adj.getBlockIncrement());
                break;
            }
            case 67: {
                if (!evt.isControlDown()) break;
                this.dec.exit();
                break;
            }
            default: {
                return;
            }
        }
        evt.consume();
    }

    @Override
    public void keyTyped(KeyEvent evt) {
        if (evt.isConsumed()) {
            return;
        }
        switch (evt.getKeyChar()) {
            case '+': 
            case '=': {
                this.isp.zoom(2.0f);
                break;
            }
            case '-': {
                this.isp.zoom(0.5f);
                break;
            }
            case '1': {
                this.isp.setZoom(1.0f);
                break;
            }
            case 'Q': 
            case 'q': {
                this.dec.exit();
                break;
            }
            case 'H': 
            case 'h': {
                if (this.helpFrame == null) {
                    this.helpFrame = new Frame("Tools");
                    this.helpFrame.add(ImgKeyListener.getHelp());
                    this.helpFrame.pack();
                    this.helpFrame.setResizable(false);
                    this.helpFrame.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent e) {
                            ImgKeyListener.this.helpFrame.setVisible(false);
                        }
                    });
                }
                if (this.helpFrame.isVisible()) {
                    this.helpFrame.setVisible(false);
                    break;
                }
                this.helpFrame.setVisible(true);
                break;
            }
            default: {
                return;
            }
        }
        evt.consume();
    }

    private int calcIncrement(KeyEvent evt, Adjustable adj) {
        int incr = evt.isControlDown() ? adj.getBlockIncrement() : adj.getUnitIncrement();
        if (evt.isShiftDown()) {
            incr *= 10;
        }
        return incr;
    }

    private static TextArea getHelp() {
        TextArea ta = new TextArea("", 17, 61, 3);
        ta.setEditable(false);
        ta.setFont(new Font("Monospaced", 0, 10));
        ta.append("The following key sequences are recognized in the \nimage display window:\n\n");
        ta.append("'-'           : zoom out by a factor of 2.\n");
        ta.append("'+' or '='    : zoom in by a factor of 2.\n");
        ta.append("'1'           : set the zoom factor to 1 (i.e. no zoom).\n");
        ta.append("<up arrow>    : scroll the image up by one pixel.\n");
        ta.append("<down arrow>  : scroll the image down by one pixel.\n");
        ta.append("<left arrow>  : scroll the image left by one pixel.\n");
        ta.append("<right arrow> : scroll the image right by one pixel.\n");
        ta.append("<page up>     : scroll the image up by a whole page.\n");
        ta.append("<page down>   : scroll the image down by a whole page.\n");
        ta.append("Ctrl+<arrow>  : scroll in the direction of the arrow a \n                page at a time instead of a pixel at a time.\n");
        ta.append("Shift+<arrow> : accelerate the scroll speed by 10.\n");
        ta.append("'Q' or 'q'    : exit the application.\n");
        ta.append("'Ctrl-C'      : exit the application.\n");
        return ta;
    }
}

