/*! Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import { expect } from 'chai';
import { describe, it } from 'mocha';
import { assign, buildPath, shallowMerge } from "../../main/typescript/AssocArray";
describe('Assoc Array Helpers test', () => {
    it('must have a properly working buildPath', () => {
        var _a;
        const target = {};
        const res = buildPath(target, "hello", "world", "from");
        expect(res.key).to.eq("from");
        expect((_a = res.target) === null || _a === void 0 ? void 0 : _a.from).eq(null);
    });
    it('must have a properly working buildPath with arrays', () => {
        let config = {};
        const res = buildPath(config, "hello[5]", "world[3]", "from[5]");
        expect(res.key).eq(5);
        expect(res.target[5]).equals(null);
        expect(config.hello[5].world[3].from[5]).to.eq(null);
    });
    it('must have a properly working buildPath with arrays 2', () => {
        let config = {};
        const res = buildPath(config, "hello[5][3]", "from[5]");
        expect(res.key).eq(5);
        expect(res.target[5]).equals(null);
        expect(config.hello[5][3].from[5]).to.eq(null);
    });
    it('must have a properly working buildPath with arrays 3', () => {
        let config = {
            value: []
        };
        const res = buildPath(config.value, "[5][3]", "from[5]");
        expect(res.key).eq(5);
        expect(res.target[5]).equals(null);
        expect(config.value[5][3].from[5]).to.eq(null);
    });
    it('simple assoc array', () => {
        var _a, _b, _c, _d;
        const target = {};
        assign(target, "hello", "world", "from").value = "me";
        expect((_b = (_a = target === null || target === void 0 ? void 0 : target["hello"]) === null || _a === void 0 ? void 0 : _a["world"]) === null || _b === void 0 ? void 0 : _b["from"]).to.be.eq("me");
        expect(!((_d = (_c = target === null || target === void 0 ? void 0 : target["hello"]) === null || _c === void 0 ? void 0 : _c["booga"]) === null || _d === void 0 ? void 0 : _d["from"])).to.be.eq(true);
    });
    it('assoc array - array config', () => {
        var _a, _b, _c, _d;
        let config = {};
        assign(config, "hello[5]", "world[3]", "from[5]").value = "me";
        console.debug(JSON.stringify(config));
        expect((_d = (_c = (_b = (_a = config === null || config === void 0 ? void 0 : config["hello"]) === null || _a === void 0 ? void 0 : _a[5]) === null || _b === void 0 ? void 0 : _b["world"]) === null || _c === void 0 ? void 0 : _c[3]["from"]) === null || _d === void 0 ? void 0 : _d[5]).to.be.eq("me");
        expect(config === null || config === void 0 ? void 0 : config.hello[5].world[3].from[5]).to.be.eq("me");
    });
    it('assoc array - array config double arr', () => {
        var _a, _b, _c;
        let config = {};
        assign(config, "hello[5][3]", "from[5]").value = "me";
        console.debug(JSON.stringify(config));
        expect((_c = (_b = (_a = config === null || config === void 0 ? void 0 : config["hello"]) === null || _a === void 0 ? void 0 : _a[5]) === null || _b === void 0 ? void 0 : _b[3]["from"]) === null || _c === void 0 ? void 0 : _c[5]).to.be.eq("me");
        expect(config === null || config === void 0 ? void 0 : config.hello[5][3].from[5]).to.be.eq("me");
    });
    it('must do shallow merge', (done) => {
        var _a, _b, _c;
        let res = shallowMerge(true, true, {
            a: "one",
            b: "two"
        }, {
            a: "one_1",
            b: "two_1",
            c: "three"
        });
        expect((_a = res === null || res === void 0 ? void 0 : res.a) === null || _a === void 0 ? void 0 : _a[0]).to.eq("one");
        expect((_b = res === null || res === void 0 ? void 0 : res.a) === null || _b === void 0 ? void 0 : _b[1]).to.eq("one_1");
        expect((_c = res === null || res === void 0 ? void 0 : res.b) === null || _c === void 0 ? void 0 : _c[1]).to.eq("two_1");
        expect(res === null || res === void 0 ? void 0 : res.c[0]).to.eq("three");
        done();
    });
    it('must do shallow merge 2', (done) => {
        let res = shallowMerge(false, true, {
            a: "one",
            b: "two"
        }, {
            a: "one_1",
            b: "two_1",
            c: "three"
        });
        expect(res === null || res === void 0 ? void 0 : res.a[0]).to.eq("one");
        expect(res === null || res === void 0 ? void 0 : res.b[0]).to.eq("two");
        expect(res === null || res === void 0 ? void 0 : res.c[0]).to.eq("three");
        done();
    });
    it('must do shallow merge 3', (done) => {
        let res = shallowMerge(true, false, {
            a: "one",
            b: "two"
        }, {
            a: "one_1",
            b: "two_1",
            c: "three"
        });
        expect(res === null || res === void 0 ? void 0 : res.a).to.eq("one_1");
        expect(res === null || res === void 0 ? void 0 : res.b).to.eq("two_1");
        expect(res === null || res === void 0 ? void 0 : res.c).to.eq("three");
        done();
    });
});
//# sourceMappingURL=AssocArrayTest.spec.js.map