/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.security.authorization.file;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.security.authorization.AbstractConfigurableAccessPolicyProvider;
import org.apache.nifi.registry.security.authorization.AccessPolicy;
import org.apache.nifi.registry.security.authorization.AccessPolicyProviderInitializationContext;
import org.apache.nifi.registry.security.authorization.AuthorizerConfigurationContext;
import org.apache.nifi.registry.security.authorization.Group;
import org.apache.nifi.registry.security.authorization.RequestAction;
import org.apache.nifi.registry.security.authorization.User;
import org.apache.nifi.registry.security.authorization.annotation.AuthorizerContext;
import org.apache.nifi.registry.security.authorization.exception.AuthorizationAccessException;
import org.apache.nifi.registry.security.authorization.exception.UninheritableAuthorizationsException;
import org.apache.nifi.registry.security.authorization.file.AuthorizationsHolder;
import org.apache.nifi.registry.security.authorization.file.FileAuthorizer;
import org.apache.nifi.registry.security.authorization.file.generated.Authorizations;
import org.apache.nifi.registry.security.authorization.file.generated.Policies;
import org.apache.nifi.registry.security.authorization.file.generated.Policy;
import org.apache.nifi.registry.security.authorization.util.AccessPolicyProviderUtils;
import org.apache.nifi.registry.security.authorization.util.InitialPolicies;
import org.apache.nifi.registry.security.authorization.util.ResourceAndAction;
import org.apache.nifi.registry.security.exception.SecurityProviderCreationException;
import org.apache.nifi.registry.security.exception.SecurityProviderDestructionException;
import org.apache.nifi.registry.security.identity.IdentityMapper;
import org.apache.nifi.registry.util.PropertyValue;
import org.apache.nifi.xml.processing.ProcessingException;
import org.apache.nifi.xml.processing.parsers.StandardDocumentProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FileAccessPolicyProvider
extends AbstractConfigurableAccessPolicyProvider {
    private static final Logger logger = LoggerFactory.getLogger(FileAccessPolicyProvider.class);
    private static final String AUTHORIZATIONS_XSD = "/authorizations.xsd";
    private static final String JAXB_AUTHORIZATIONS_PATH = "org.apache.nifi.registry.security.authorization.file.generated";
    private static final JAXBContext JAXB_AUTHORIZATIONS_CONTEXT = FileAccessPolicyProvider.initializeJaxbContext("org.apache.nifi.registry.security.authorization.file.generated");
    private static final XMLOutputFactory XML_OUTPUT_FACTORY = XMLOutputFactory.newInstance();
    private static final String POLICY_ELEMENT = "policy";
    private static final String POLICY_USER_ELEMENT = "policyUser";
    private static final String POLICY_GROUP_ELEMENT = "policyGroup";
    private static final String IDENTIFIER_ATTR = "identifier";
    private static final String RESOURCE_ATTR = "resource";
    private static final String ACTIONS_ATTR = "actions";
    static final String READ_CODE = "R";
    static final String WRITE_CODE = "W";
    static final String DELETE_CODE = "D";
    static final String PROP_AUTHORIZATIONS_FILE = "Authorizations File";
    private IdentityMapper identityMapper;
    private Schema authorizationsSchema;
    private File authorizationsFile;
    private String initialAdminIdentity;
    private Set<String> nifiIdentities;
    private String nifiGroupName;
    private final AtomicReference<AuthorizationsHolder> authorizationsHolder = new AtomicReference();

    private static JAXBContext initializeJaxbContext(String contextPath) {
        try {
            return JAXBContext.newInstance((String)contextPath, (ClassLoader)FileAuthorizer.class.getClassLoader());
        }
        catch (JAXBException e) {
            throw new RuntimeException("Unable to create JAXBContext.");
        }
    }

    @Override
    public void doInitialize(AccessPolicyProviderInitializationContext initializationContext) throws SecurityProviderCreationException {
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            this.authorizationsSchema = schemaFactory.newSchema(FileAuthorizer.class.getResource(AUTHORIZATIONS_XSD));
        }
        catch (Exception e) {
            throw new SecurityProviderCreationException((Throwable)e);
        }
    }

    @Override
    public void doOnConfigured(AuthorizerConfigurationContext configurationContext) throws SecurityProviderCreationException {
        try {
            PropertyValue authorizationsPath = configurationContext.getProperty(PROP_AUTHORIZATIONS_FILE);
            if (StringUtils.isBlank((CharSequence)authorizationsPath.getValue())) {
                throw new SecurityProviderCreationException("The authorizations file must be specified.");
            }
            this.authorizationsFile = new File(authorizationsPath.getValue());
            if (!this.authorizationsFile.exists()) {
                logger.info("Creating new authorizations file at {}", (Object)this.authorizationsFile.getAbsolutePath());
                this.saveAuthorizations(new Authorizations());
            }
            this.initialAdminIdentity = AccessPolicyProviderUtils.getInitialAdminIdentity(configurationContext, this.identityMapper);
            this.nifiIdentities = AccessPolicyProviderUtils.getNiFiIdentities(configurationContext, this.identityMapper);
            this.nifiGroupName = AccessPolicyProviderUtils.getNiFiGroupName(configurationContext, this.identityMapper);
            this.load();
            logger.info("Authorizations file loaded at {}", (Object)new Date());
        }
        catch (JAXBException | SAXException e) {
            throw new SecurityProviderCreationException(e);
        }
    }

    public Set<AccessPolicy> getAccessPolicies() throws AuthorizationAccessException {
        return this.authorizationsHolder.get().getAllPolicies();
    }

    public synchronized AccessPolicy addAccessPolicy(AccessPolicy accessPolicy) throws AuthorizationAccessException {
        if (accessPolicy == null) {
            throw new IllegalArgumentException("AccessPolicy cannot be null");
        }
        Policy policy = this.createJAXBPolicy(accessPolicy);
        AuthorizationsHolder holder = this.authorizationsHolder.get();
        Authorizations authorizations = holder.getAuthorizations();
        authorizations.getPolicies().getPolicy().add(policy);
        this.saveAndRefreshHolder(authorizations);
        return this.authorizationsHolder.get().getPoliciesById().get(accessPolicy.getIdentifier());
    }

    public AccessPolicy getAccessPolicy(String identifier) throws AuthorizationAccessException {
        if (identifier == null) {
            return null;
        }
        AuthorizationsHolder holder = this.authorizationsHolder.get();
        return holder.getPoliciesById().get(identifier);
    }

    public AccessPolicy getAccessPolicy(String resourceIdentifier, RequestAction action) throws AuthorizationAccessException {
        return this.authorizationsHolder.get().getAccessPolicy(resourceIdentifier, action);
    }

    public synchronized AccessPolicy updateAccessPolicy(AccessPolicy accessPolicy) throws AuthorizationAccessException {
        if (accessPolicy == null) {
            throw new IllegalArgumentException("AccessPolicy cannot be null");
        }
        AuthorizationsHolder holder = this.authorizationsHolder.get();
        Authorizations authorizations = holder.getAuthorizations();
        Policy updatePolicy = null;
        for (Policy policy : authorizations.getPolicies().getPolicy()) {
            if (!policy.getIdentifier().equals(accessPolicy.getIdentifier())) continue;
            updatePolicy = policy;
            break;
        }
        if (updatePolicy == null) {
            return null;
        }
        this.transferUsersAndGroups(accessPolicy, updatePolicy);
        this.saveAndRefreshHolder(authorizations);
        return this.authorizationsHolder.get().getPoliciesById().get(accessPolicy.getIdentifier());
    }

    public synchronized AccessPolicy deleteAccessPolicy(AccessPolicy accessPolicy) throws AuthorizationAccessException {
        if (accessPolicy == null) {
            throw new IllegalArgumentException("AccessPolicy cannot be null");
        }
        return this.deleteAccessPolicy(accessPolicy.getIdentifier());
    }

    private synchronized AccessPolicy deleteAccessPolicy(String accessPolicyIdentifer) throws AuthorizationAccessException {
        if (accessPolicyIdentifer == null) {
            throw new IllegalArgumentException("Access policy identifier cannot be null");
        }
        AuthorizationsHolder holder = this.authorizationsHolder.get();
        AccessPolicy deletedPolicy = holder.getPoliciesById().get(accessPolicyIdentifer);
        if (deletedPolicy == null) {
            return null;
        }
        Authorizations authorizations = holder.getAuthorizations();
        Iterator<Policy> policyIter = authorizations.getPolicies().getPolicy().iterator();
        while (policyIter.hasNext()) {
            Policy policy = policyIter.next();
            if (!policy.getIdentifier().equals(accessPolicyIdentifer)) continue;
            policyIter.remove();
            break;
        }
        this.saveAndRefreshHolder(authorizations);
        return deletedPolicy;
    }

    AuthorizationsHolder getAuthorizationsHolder() {
        return this.authorizationsHolder.get();
    }

    @AuthorizerContext
    public void setIdentityMapper(IdentityMapper identityMapper) {
        this.identityMapper = identityMapper;
    }

    public synchronized void inheritFingerprint(String fingerprint) throws AuthorizationAccessException {
        this.parsePolicies(fingerprint).forEach(policy -> this.addAccessPolicy((AccessPolicy)policy));
    }

    public void checkInheritability(String proposedFingerprint) throws AuthorizationAccessException, UninheritableAuthorizationsException {
        try {
            this.parsePolicies(proposedFingerprint);
        }
        catch (AuthorizationAccessException e) {
            throw new UninheritableAuthorizationsException("Unable to parse the proposed fingerprint: " + String.valueOf((Object)e));
        }
        if (!this.getAccessPolicies().isEmpty()) {
            throw new UninheritableAuthorizationsException("Proposed fingerprint is not inheritable because the current access policies is not empty.");
        }
    }

    public String getFingerprint() throws AuthorizationAccessException {
        ArrayList<AccessPolicy> policies = new ArrayList<AccessPolicy>(this.getAccessPolicies());
        Collections.sort(policies, Comparator.comparing(AccessPolicy::getIdentifier));
        XMLStreamWriter writer = null;
        StringWriter out = new StringWriter();
        try {
            writer = XML_OUTPUT_FACTORY.createXMLStreamWriter(out);
            writer.writeStartDocument();
            writer.writeStartElement("accessPolicies");
            for (AccessPolicy policy : policies) {
                this.writePolicy(writer, policy);
            }
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.flush();
        }
        catch (XMLStreamException e) {
            throw new AuthorizationAccessException("Unable to generate fingerprint", (Throwable)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (XMLStreamException xMLStreamException) {}
            }
        }
        return out.toString();
    }

    private List<AccessPolicy> parsePolicies(String fingerprint) {
        ArrayList<AccessPolicy> policies = new ArrayList<AccessPolicy>();
        byte[] fingerprintBytes = fingerprint.getBytes(StandardCharsets.UTF_8);
        try (ByteArrayInputStream in = new ByteArrayInputStream(fingerprintBytes);){
            StandardDocumentProvider documentProvider = new StandardDocumentProvider();
            Document document = documentProvider.parse((InputStream)in);
            Element rootElement = document.getDocumentElement();
            NodeList policyNodes = rootElement.getElementsByTagName(POLICY_ELEMENT);
            for (int i = 0; i < policyNodes.getLength(); ++i) {
                Node policyNode = policyNodes.item(i);
                policies.add(this.parsePolicy((Element)policyNode));
            }
        }
        catch (IOException | ProcessingException e) {
            throw new AuthorizationAccessException("Unable to parse fingerprint", e);
        }
        return policies;
    }

    private AccessPolicy parsePolicy(Element element) {
        AccessPolicy.Builder builder = new AccessPolicy.Builder().identifier(element.getAttribute(IDENTIFIER_ATTR)).resource(element.getAttribute(RESOURCE_ATTR));
        String actions = element.getAttribute(ACTIONS_ATTR);
        if (actions.equals(RequestAction.READ.name())) {
            builder.action(RequestAction.READ);
        } else if (actions.equals(RequestAction.WRITE.name())) {
            builder.action(RequestAction.WRITE);
        } else if (actions.equals(RequestAction.DELETE.name())) {
            builder.action(RequestAction.DELETE);
        } else {
            throw new IllegalStateException("Unknown Policy Action: " + actions);
        }
        NodeList policyUsers = element.getElementsByTagName(POLICY_USER_ELEMENT);
        for (int i = 0; i < policyUsers.getLength(); ++i) {
            Element policyUserNode = (Element)policyUsers.item(i);
            builder.addUser(policyUserNode.getAttribute(IDENTIFIER_ATTR));
        }
        NodeList policyGroups = element.getElementsByTagName(POLICY_GROUP_ELEMENT);
        for (int i = 0; i < policyGroups.getLength(); ++i) {
            Element policyGroupNode = (Element)policyGroups.item(i);
            builder.addGroup(policyGroupNode.getAttribute(IDENTIFIER_ATTR));
        }
        return builder.build();
    }

    private void writePolicy(XMLStreamWriter writer, AccessPolicy policy) throws XMLStreamException {
        ArrayList policyUsers = new ArrayList(policy.getUsers());
        Collections.sort(policyUsers);
        ArrayList policyGroups = new ArrayList(policy.getGroups());
        Collections.sort(policyGroups);
        writer.writeStartElement(POLICY_ELEMENT);
        writer.writeAttribute(IDENTIFIER_ATTR, policy.getIdentifier());
        writer.writeAttribute(RESOURCE_ATTR, policy.getResource());
        writer.writeAttribute(ACTIONS_ATTR, policy.getAction().name());
        for (String policyUser : policyUsers) {
            writer.writeStartElement(POLICY_USER_ELEMENT);
            writer.writeAttribute(IDENTIFIER_ATTR, policyUser);
            writer.writeEndElement();
        }
        for (String policyGroup : policyGroups) {
            writer.writeStartElement(POLICY_GROUP_ELEMENT);
            writer.writeAttribute(IDENTIFIER_ATTR, policyGroup);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private synchronized void load() throws JAXBException, SAXException {
        boolean hasNiFiIdentities;
        Authorizations authorizations = this.unmarshallAuthorizations();
        if (authorizations.getPolicies() == null) {
            authorizations.setPolicies(new Policies());
        }
        AuthorizationsHolder authorizationsHolder = new AuthorizationsHolder(authorizations);
        boolean emptyAuthorizations = authorizationsHolder.getAllPolicies().isEmpty();
        boolean hasInitialAdminIdentity = this.initialAdminIdentity != null && !StringUtils.isBlank((CharSequence)this.initialAdminIdentity);
        boolean bl = hasNiFiIdentities = this.nifiIdentities != null && !this.nifiIdentities.isEmpty();
        if (emptyAuthorizations) {
            if (hasInitialAdminIdentity) {
                logger.info("Populating authorizations for Initial Admin: '{}'", (Object)this.initialAdminIdentity);
                this.populateInitialAdmin(authorizations);
            }
            if (hasNiFiIdentities) {
                logger.info("Populating authorizations for NiFi identities: [{}]", (Object)StringUtils.join(this.nifiIdentities, (String)";"));
                this.populateNiFiIdentities(authorizations);
            }
            if (!StringUtils.isEmpty((CharSequence)this.nifiGroupName)) {
                logger.info("Populating authorizations for NiFi identity group: [{}]", (Object)this.nifiGroupName);
                this.populateNiFiGroup(authorizations);
            }
            this.saveAndRefreshHolder(authorizations);
        } else {
            this.authorizationsHolder.set(authorizationsHolder);
        }
    }

    private void saveAuthorizations(Authorizations authorizations) throws JAXBException {
        Marshaller marshaller = JAXB_AUTHORIZATIONS_CONTEXT.createMarshaller();
        marshaller.setSchema(this.authorizationsSchema);
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal((Object)authorizations, this.authorizationsFile);
    }

    private Authorizations unmarshallAuthorizations() throws JAXBException {
        Unmarshaller unmarshaller = JAXB_AUTHORIZATIONS_CONTEXT.createUnmarshaller();
        unmarshaller.setSchema(this.authorizationsSchema);
        JAXBElement element = unmarshaller.unmarshal((Source)new StreamSource(this.authorizationsFile), Authorizations.class);
        return (Authorizations)element.getValue();
    }

    private void populateInitialAdmin(Authorizations authorizations) {
        User initialAdmin = this.getUserGroupProvider().getUserByIdentity(this.initialAdminIdentity);
        if (initialAdmin == null) {
            throw new SecurityProviderCreationException("Unable to locate initial admin " + this.initialAdminIdentity + " to seed policies");
        }
        for (ResourceAndAction resourceAction : InitialPolicies.ADMIN_POLICIES) {
            String resource = resourceAction.getResource().getIdentifier();
            String actionCode = this.getActionCode(resourceAction.getAction());
            this.addUserToAccessPolicy(authorizations, resource, initialAdmin.getIdentifier(), actionCode);
        }
    }

    private void populateNiFiIdentities(Authorizations authorizations) {
        for (String nifiIdentity : this.nifiIdentities) {
            User nifiUser = this.getUserGroupProvider().getUserByIdentity(nifiIdentity);
            if (nifiUser == null) {
                throw new SecurityProviderCreationException("Unable to locate NiFi identities'" + nifiIdentity + "' to seed policies.");
            }
            for (ResourceAndAction resourceAction : InitialPolicies.NIFI_POLICIES) {
                String resource = resourceAction.getResource().getIdentifier();
                String actionCode = this.getActionCode(resourceAction.getAction());
                this.addUserToAccessPolicy(authorizations, resource, nifiUser.getIdentifier(), actionCode);
            }
        }
    }

    private void populateNiFiGroup(Authorizations authorizations) {
        Group nifiGroup = AccessPolicyProviderUtils.getGroup(this.nifiGroupName, this.getUserGroupProvider());
        for (ResourceAndAction resourceAction : InitialPolicies.NIFI_POLICIES) {
            String resource = resourceAction.getResource().getIdentifier();
            String actionCode = this.getActionCode(resourceAction.getAction());
            this.addGroupToAccessPolicy(authorizations, resource, nifiGroup.getIdentifier(), actionCode);
        }
    }

    private void addGroupToAccessPolicy(Authorizations authorizations, String resource, String groupIdentifier, String actionCode) {
        Optional<Policy> policyOptional = authorizations.getPolicies().getPolicy().stream().filter(policy -> policy.getResource().equals(resource)).filter(policy -> policy.getAction().equals(actionCode)).findAny();
        if (policyOptional.isPresent()) {
            Policy policy2 = policyOptional.get();
            Policy.Group group = new Policy.Group();
            group.setIdentifier(groupIdentifier);
            policy2.getGroup().add(group);
        } else {
            AccessPolicy.Builder accessPolicyBuilder = new AccessPolicy.Builder().identifierGenerateFromSeed(resource + actionCode).resource(resource).addGroup(groupIdentifier).action(this.getAction(actionCode));
            authorizations.getPolicies().getPolicy().add(this.createJAXBPolicy(accessPolicyBuilder.build()));
        }
    }

    private void addUserToAccessPolicy(Authorizations authorizations, String resource, String userIdentifier, String actionCode) {
        Policy foundPolicy = null;
        for (Policy policy : authorizations.getPolicies().getPolicy()) {
            if (!policy.getResource().equals(resource) || !policy.getAction().equals(actionCode)) continue;
            foundPolicy = policy;
            break;
        }
        if (foundPolicy == null) {
            String uuidSeed = resource + actionCode;
            AccessPolicy.Builder builder = new AccessPolicy.Builder().identifierGenerateFromSeed(uuidSeed).resource(resource).addUser(userIdentifier).action(this.getAction(actionCode));
            AccessPolicy accessPolicy = builder.build();
            Policy jaxbPolicy = this.createJAXBPolicy(accessPolicy);
            authorizations.getPolicies().getPolicy().add(jaxbPolicy);
        } else {
            Policy.User policyUser = new Policy.User();
            policyUser.setIdentifier(userIdentifier);
            foundPolicy.getUser().add(policyUser);
        }
    }

    private Policy createJAXBPolicy(AccessPolicy accessPolicy) {
        Policy policy = new Policy();
        policy.setIdentifier(accessPolicy.getIdentifier());
        policy.setResource(accessPolicy.getResource());
        policy.setAction(this.getActionCode(accessPolicy.getAction()));
        this.transferUsersAndGroups(accessPolicy, policy);
        return policy;
    }

    private String getActionCode(RequestAction action) {
        switch (action) {
            case READ: {
                return READ_CODE;
            }
            case WRITE: {
                return WRITE_CODE;
            }
            case DELETE: {
                return DELETE_CODE;
            }
        }
        throw new IllegalStateException("Unknown action: " + String.valueOf(action));
    }

    private RequestAction getAction(String actionCode) {
        switch (actionCode) {
            case "R": {
                return RequestAction.READ;
            }
            case "W": {
                return RequestAction.WRITE;
            }
            case "D": {
                return RequestAction.DELETE;
            }
        }
        throw new IllegalStateException("Unknown action: " + actionCode);
    }

    private void transferUsersAndGroups(AccessPolicy accessPolicy, Policy policy) {
        policy.getUser().clear();
        for (String userIdentifier : accessPolicy.getUsers()) {
            Policy.User policyUser = new Policy.User();
            policyUser.setIdentifier(userIdentifier);
            policy.getUser().add(policyUser);
        }
        policy.getGroup().clear();
        for (String groupIdentifier : accessPolicy.getGroups()) {
            Policy.Group policyGroup = new Policy.Group();
            policyGroup.setIdentifier(groupIdentifier);
            policy.getGroup().add(policyGroup);
        }
    }

    private synchronized void saveAndRefreshHolder(Authorizations authorizations) throws AuthorizationAccessException {
        try {
            this.saveAuthorizations(authorizations);
            this.authorizationsHolder.set(new AuthorizationsHolder(authorizations));
        }
        catch (JAXBException e) {
            throw new AuthorizationAccessException("Unable to save Authorizations", (Throwable)e);
        }
    }

    public void preDestruction() throws SecurityProviderDestructionException {
    }
}

