/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.sqlscript;

import java.sql.SQLException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.resource.Resource;
import org.flywaydb.core.internal.exception.FlywaySqlException;
import org.flywaydb.core.internal.sqlscript.SqlStatement;

public class FlywaySqlScriptException
extends FlywaySqlException {
    private static final Log LOG = LogFactory.getLog(FlywaySqlScriptException.class);
    private final Resource resource;
    private final SqlStatement statement;
    public static final String STATEMENT_MESSAGE = "Run Flyway with -X option to see the actual statement causing the problem";

    public FlywaySqlScriptException(Resource resource, SqlStatement statement, SQLException sqlException) {
        super((String)(resource == null ? "Script failed" : "Script " + resource.getFilename() + " failed"), sqlException);
        this.resource = resource;
        this.statement = statement;
    }

    public int getLineNumber() {
        return this.statement == null ? -1 : this.statement.getLineNumber();
    }

    public String getStatement() {
        return this.statement == null ? "" : this.statement.getSql();
    }

    @Override
    public String getMessage() {
        Object message = super.getMessage();
        if (this.resource != null) {
            message = (String)message + "Location   : " + this.resource.getAbsolutePath() + " (" + this.resource.getAbsolutePathOnDisk() + ")\n";
        }
        if (this.statement != null) {
            message = (String)message + "Line       : " + this.getLineNumber() + "\n";
            message = (String)message + "Statement  : " + (LOG.isDebugEnabled() ? this.getStatement() : STATEMENT_MESSAGE) + "\n";
        }
        return message;
    }

    public Resource getResource() {
        return this.resource;
    }
}

