/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization.method;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.springframework.core.annotation.AnnotationConfigurationException;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.annotation.RepeatableContainers;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.security.authorization.method.PrePostTemplateDefaults;
import org.springframework.util.PropertyPlaceholderHelper;

final class AuthorizationAnnotationUtils {
    private static final DefaultConversionService conversionService = new DefaultConversionService();

    static <A extends Annotation> Function<AnnotatedElement, A> withDefaults(Class<A> type, PrePostTemplateDefaults defaults) {
        Function<MergedAnnotation, Annotation> map = mergedAnnotation -> {
            if (mergedAnnotation.getMetaSource() == null) {
                return mergedAnnotation.synthesize();
            }
            PropertyPlaceholderHelper helper = new PropertyPlaceholderHelper("{", "}", null, defaults.isIgnoreUnknown());
            String expression = (String)mergedAnnotation.asMap(new MergedAnnotation.Adapt[0]).get("value");
            Map annotationProperties = mergedAnnotation.getMetaSource().asMap(new MergedAnnotation.Adapt[0]);
            HashMap<String, String> stringProperties = new HashMap<String, String>();
            for (Map.Entry property : annotationProperties.entrySet()) {
                String key = (String)property.getKey();
                Object value = property.getValue();
                String asString = value instanceof String ? (String)value : (String)conversionService.convert(value, String.class);
                stringProperties.put(key, asString);
            }
            AnnotatedElement annotatedElement = (AnnotatedElement)mergedAnnotation.getSource();
            String value = helper.replacePlaceholders(expression, stringProperties::get);
            HashMap<String, String> properties = new HashMap<String, String>(mergedAnnotation.asMap(new MergedAnnotation.Adapt[0]));
            properties.put("value", value);
            return MergedAnnotation.of((AnnotatedElement)annotatedElement, (Class)type, properties).synthesize();
        };
        return annotatedElement -> AuthorizationAnnotationUtils.findDistinctAnnotation(annotatedElement, type, map);
    }

    static <A extends Annotation> Function<AnnotatedElement, A> withDefaults(Class<A> type) {
        return annotatedElement -> AuthorizationAnnotationUtils.findDistinctAnnotation(annotatedElement, type, MergedAnnotation::synthesize);
    }

    static <A extends Annotation> A findUniqueAnnotation(Method method, Class<A> annotationType) {
        return (A)AuthorizationAnnotationUtils.findDistinctAnnotation(method, annotationType, MergedAnnotation::synthesize);
    }

    static <A extends Annotation> A findUniqueAnnotation(Class<?> type, Class<A> annotationType) {
        return (A)AuthorizationAnnotationUtils.findDistinctAnnotation(type, annotationType, MergedAnnotation::synthesize);
    }

    static <A extends Annotation> A findUniqueAnnotation(Method method, Class<A> annotationType, Function<MergedAnnotation<A>, A> map) {
        return AuthorizationAnnotationUtils.findDistinctAnnotation(method, annotationType, map);
    }

    static <A extends Annotation> A findUniqueAnnotation(Class<?> type, Class<A> annotationType, Function<MergedAnnotation<A>, A> map) {
        return AuthorizationAnnotationUtils.findDistinctAnnotation(type, annotationType, map);
    }

    private static <A extends Annotation> A findDistinctAnnotation(AnnotatedElement annotatedElement, Class<A> annotationType, Function<MergedAnnotation<A>, A> map) {
        MergedAnnotations mergedAnnotations = MergedAnnotations.from((AnnotatedElement)annotatedElement, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY, (RepeatableContainers)RepeatableContainers.none());
        List<A> annotations = mergedAnnotations.stream(annotationType).map(MergedAnnotation::withNonMergedAttributes).map(map).distinct().toList();
        return (A)(switch (annotations.size()) {
            case 0 -> null;
            case 1 -> (Annotation)annotations.get(0);
            default -> throw new AnnotationConfigurationException("Please ensure there is one unique annotation of type @%s attributed to %s. Found %d competing annotations: %s".formatted(annotationType.getName(), annotatedElement, annotations.size(), annotations));
        });
    }

    private AuthorizationAnnotationUtils() {
    }

    static {
        conversionService.addConverter((GenericConverter)new ClassToStringConverter());
    }

    static class ClassToStringConverter
    implements GenericConverter {
        ClassToStringConverter() {
        }

        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return Collections.singleton(new GenericConverter.ConvertiblePair(Class.class, String.class));
        }

        public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            return source != null ? source.toString() : null;
        }
    }
}

