/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.extension.repo;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Comparator;
import java.util.Objects;
import org.apache.nifi.registry.link.LinkableEntity;

@XmlRootElement
public class ExtensionRepoGroup
extends LinkableEntity
implements Comparable<ExtensionRepoGroup> {
    private String bucketName;
    private String groupId;

    @Schema(description="The bucket name")
    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    @Schema(description="The group id")
    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @Override
    public int compareTo(ExtensionRepoGroup o) {
        return Comparator.comparing(ExtensionRepoGroup::getGroupId).thenComparing(ExtensionRepoGroup::getBucketName).compare(this, o);
    }

    public int hashCode() {
        return Objects.hash(this.bucketName, this.groupId);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExtensionRepoGroup other = (ExtensionRepoGroup)obj;
        return Objects.equals(this.getBucketName(), other.getBucketName()) && Objects.equals(this.getGroupId(), other.getGroupId());
    }
}

