/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.dto.status;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Date;
import java.util.List;
import org.apache.nifi.web.api.dto.status.NodeRemoteProcessGroupStatusSnapshotDTO;
import org.apache.nifi.web.api.dto.status.RemoteProcessGroupStatusSnapshotDTO;
import org.apache.nifi.web.api.dto.util.TimeAdapter;

@XmlType(name="remoteProcessGroupStatus")
public class RemoteProcessGroupStatusDTO {
    private String groupId;
    private String id;
    private String name;
    private String targetUri;
    private String transmissionStatus;
    private Date statsLastRefreshed;
    private String validationStatus;
    private RemoteProcessGroupStatusSnapshotDTO aggregateSnapshot;
    private List<NodeRemoteProcessGroupStatusSnapshotDTO> nodeSnapshots;

    @Schema(description="The unique ID of the process group that the Processor belongs to")
    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @Schema(description="The unique ID of the Processor")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Schema(description="The name of the remote process group.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Schema(description="The transmission status of the remote process group.")
    public String getTransmissionStatus() {
        return this.transmissionStatus;
    }

    public void setTransmissionStatus(String transmissionStatus) {
        this.transmissionStatus = transmissionStatus;
    }

    @Schema(description="The URI of the target system.")
    public String getTargetUri() {
        return this.targetUri;
    }

    public void setTargetUri(String targetUri) {
        this.targetUri = targetUri;
    }

    @Schema(description="A status snapshot that represents the aggregate stats of all nodes in the cluster. If the NiFi instance is a standalone instance, rather than a cluster, this represents the stats of the single instance.")
    public RemoteProcessGroupStatusSnapshotDTO getAggregateSnapshot() {
        return this.aggregateSnapshot;
    }

    public void setAggregateSnapshot(RemoteProcessGroupStatusSnapshotDTO aggregateSnapshot) {
        this.aggregateSnapshot = aggregateSnapshot;
    }

    @Schema(description="A status snapshot for each node in the cluster. If the NiFi instance is a standalone instance, rather than a cluster, this may be null.")
    public List<NodeRemoteProcessGroupStatusSnapshotDTO> getNodeSnapshots() {
        return this.nodeSnapshots;
    }

    public void setNodeSnapshots(List<NodeRemoteProcessGroupStatusSnapshotDTO> nodeSnapshots) {
        this.nodeSnapshots = nodeSnapshots;
    }

    @XmlJavaTypeAdapter(value=TimeAdapter.class)
    @Schema(description="The time the status for the process group was last refreshed.", type="string")
    public Date getStatsLastRefreshed() {
        return this.statsLastRefreshed;
    }

    public void setStatsLastRefreshed(Date statsLastRefreshed) {
        this.statsLastRefreshed = statsLastRefreshed;
    }

    @Schema(description="Indicates whether the component is valid, invalid, or still in the process of validating (i.e., it is unknown whether or not the component is valid)", accessMode=Schema.AccessMode.READ_ONLY, allowableValues={"VALID", "INVALID", "VALIDATING"})
    public String getValidationStatus() {
        return this.validationStatus;
    }

    public void setValidationStatus(String validationStatus) {
        this.validationStatus = validationStatus;
    }
}

