/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.jbig2;

import java.awt.Rectangle;
import java.util.Arrays;

public class Bitmap {
    private final int height;
    private final int width;
    private final int rowStride;
    private byte[] bitmap;

    public Bitmap(int n, int n2) {
        this.height = n2;
        this.width = n;
        this.rowStride = n + 7 >> 3;
        this.bitmap = new byte[this.height * this.rowStride];
    }

    public byte getPixel(int n, int n2) {
        int n3 = this.getByteIndex(n, n2);
        int n4 = this.getBitOffset(n);
        int n5 = 7 - n4;
        return (byte)(this.getByte(n3) >> n5 & 1);
    }

    public void setPixel(int n, int n2, byte by) {
        byte by2;
        int n3 = this.getByteIndex(n, n2);
        int n4 = this.getBitOffset(n);
        int n5 = 7 - n4;
        byte by3 = this.bitmap[n3];
        this.bitmap[n3] = by2 = (byte)(by3 | by << n5);
    }

    public int getByteIndex(int n, int n2) {
        return n2 * this.rowStride + (n >> 3);
    }

    public byte[] getByteArray() {
        return this.bitmap;
    }

    public byte getByte(int n) {
        return this.bitmap[n];
    }

    public void setByte(int n, byte by) {
        this.bitmap[n] = by;
    }

    public int getByteAsInteger(int n) {
        return this.bitmap[n] & 0xFF;
    }

    public int getBitOffset(int n) {
        return n & 7;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getRowStride() {
        return this.rowStride;
    }

    public Rectangle getBounds() {
        return new Rectangle(0, 0, this.width, this.height);
    }

    public int getMemorySize() {
        return this.getLength();
    }

    public int getLength() {
        return this.bitmap.length;
    }

    public void fillBitmap(byte by) {
        Arrays.fill(this.bitmap, by);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Bitmap)) {
            return false;
        }
        Bitmap bitmap = (Bitmap)object;
        return Arrays.equals(this.bitmap, bitmap.bitmap);
    }

    public static void arraycopy(Bitmap bitmap, int n, Bitmap bitmap2, int n2, int n3) {
        System.arraycopy(bitmap.bitmap, n, bitmap2.bitmap, n2, n3);
    }
}

