# formFieldMultiMap

@@@ div { .group-scala }

## Signature

@@signature [FormFieldDirectives.scala](/http/src/main/scala/org/apache/pekko/http/scaladsl/server/directives/FormFieldDirectives.scala) { #formFieldMultiMap }

@@@

## Description

Extracts all HTTP form fields at once as a multi-map of type @scala[`Map[String, List[String]]`]@java[`Map<String, List<String>>`] mapping
a form name to a list of all its values. Data posted from [HTML Forms](https://www.w3.org/TR/html401/interact/forms.html#h-17.13.4) is either of type `application/x-www-form-urlencoded` or of type `multipart/form-data`.

This directive can be used if form fields can occur several times.

The order of values is *not* specified.

@scala[See @ref[formFields](formFields.md) for an in-depth description.]

## Warning

Use of this directive can result in performance degradation or even in `OutOfMemoryError` s.
See @scala[@ref[formFieldSeq](formFieldSeq.md)]@java[@ref[formFieldList](formFieldSeq.md)] for details.

## Example

Scala
:  @@snip [FormFieldDirectivesExamplesSpec.scala](/docs/src/test/scala/docs/http/scaladsl/server/directives/FormFieldDirectivesExamplesSpec.scala) { #formFieldMultiMap }

Java
:  @@snip [FormFieldDirectivesExamplesTest.java](/docs/src/test/java/docs/http/javadsl/server/directives/FormFieldDirectivesExamplesTest.java) { #formFieldMultiMap }
