/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataDeviceAll is the corresponding interface of BACnetConstructedDataDeviceAll
type BACnetConstructedDataDeviceAll interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// IsBACnetConstructedDataDeviceAll is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataDeviceAll()
	// CreateBuilder creates a BACnetConstructedDataDeviceAllBuilder
	CreateBACnetConstructedDataDeviceAllBuilder() BACnetConstructedDataDeviceAllBuilder
}

// _BACnetConstructedDataDeviceAll is the data-structure of this message
type _BACnetConstructedDataDeviceAll struct {
	BACnetConstructedDataContract
}

var _ BACnetConstructedDataDeviceAll = (*_BACnetConstructedDataDeviceAll)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataDeviceAll)(nil)

// NewBACnetConstructedDataDeviceAll factory function for _BACnetConstructedDataDeviceAll
func NewBACnetConstructedDataDeviceAll(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataDeviceAll {
	_result := &_BACnetConstructedDataDeviceAll{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataDeviceAllBuilder is a builder for BACnetConstructedDataDeviceAll
type BACnetConstructedDataDeviceAllBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() BACnetConstructedDataDeviceAllBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataDeviceAll or returns an error if something is wrong
	Build() (BACnetConstructedDataDeviceAll, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataDeviceAll
}

// NewBACnetConstructedDataDeviceAllBuilder() creates a BACnetConstructedDataDeviceAllBuilder
func NewBACnetConstructedDataDeviceAllBuilder() BACnetConstructedDataDeviceAllBuilder {
	return &_BACnetConstructedDataDeviceAllBuilder{_BACnetConstructedDataDeviceAll: new(_BACnetConstructedDataDeviceAll)}
}

type _BACnetConstructedDataDeviceAllBuilder struct {
	*_BACnetConstructedDataDeviceAll

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataDeviceAllBuilder) = (*_BACnetConstructedDataDeviceAllBuilder)(nil)

func (b *_BACnetConstructedDataDeviceAllBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataDeviceAll
}

func (b *_BACnetConstructedDataDeviceAllBuilder) WithMandatoryFields() BACnetConstructedDataDeviceAllBuilder {
	return b
}

func (b *_BACnetConstructedDataDeviceAllBuilder) Build() (BACnetConstructedDataDeviceAll, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataDeviceAll.deepCopy(), nil
}

func (b *_BACnetConstructedDataDeviceAllBuilder) MustBuild() BACnetConstructedDataDeviceAll {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataDeviceAllBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataDeviceAllBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataDeviceAllBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataDeviceAllBuilder().(*_BACnetConstructedDataDeviceAllBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataDeviceAllBuilder creates a BACnetConstructedDataDeviceAllBuilder
func (b *_BACnetConstructedDataDeviceAll) CreateBACnetConstructedDataDeviceAllBuilder() BACnetConstructedDataDeviceAllBuilder {
	if b == nil {
		return NewBACnetConstructedDataDeviceAllBuilder()
	}
	return &_BACnetConstructedDataDeviceAllBuilder{_BACnetConstructedDataDeviceAll: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataDeviceAll) GetObjectTypeArgument() BACnetObjectType {
	return BACnetObjectType_DEVICE
}

func (m *_BACnetConstructedDataDeviceAll) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_ALL
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataDeviceAll) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataDeviceAll(structType any) BACnetConstructedDataDeviceAll {
	if casted, ok := structType.(BACnetConstructedDataDeviceAll); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataDeviceAll); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataDeviceAll) GetTypeName() string {
	return "BACnetConstructedDataDeviceAll"
}

func (m *_BACnetConstructedDataDeviceAll) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_BACnetConstructedDataDeviceAll) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataDeviceAll) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataDeviceAll BACnetConstructedDataDeviceAll, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataDeviceAll"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataDeviceAll")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Validation
	if !(bool((1) == (2))) {
		return nil, errors.WithStack(utils.ParseValidationError{Message: "All should never occur in context of constructed data. If it does please report"})
	}

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataDeviceAll"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataDeviceAll")
	}

	return m, nil
}

func (m *_BACnetConstructedDataDeviceAll) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataDeviceAll) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataDeviceAll"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataDeviceAll")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataDeviceAll"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataDeviceAll")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataDeviceAll) IsBACnetConstructedDataDeviceAll() {}

func (m *_BACnetConstructedDataDeviceAll) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataDeviceAll) deepCopy() *_BACnetConstructedDataDeviceAll {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataDeviceAllCopy := &_BACnetConstructedDataDeviceAll{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
	}
	_BACnetConstructedDataDeviceAllCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataDeviceAllCopy
}

func (m *_BACnetConstructedDataDeviceAll) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
