/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.openprotocol.readwrite;

import java.util.HashMap;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum ApplicationCommunicationError {
  NoError((int) 0),
  InvalidData((int) 1),
  ParameterSetIdNotPresent((int) 2),
  ParameterSetCanNotBeSet((int) 3),
  ParameterSetNotRunning((int) 4),
  VinUploadSubscriptionAlreadyExists((int) 6),
  VinUploadSubscriptionDoesNotExist((int) 7),
  VinInputSourceNotGranted((int) 8),
  LastTighteningResultSubscriptionAlreadyExists((int) 9),
  LastTighteningResultSubscriptionDoesNowExist((int) 10),
  AlarmSubscriptionAlreadyExists((int) 11),
  AlarmSubscriptionDoesNotExist((int) 12),
  ParameterSetSubscriptionAlreadyExists((int) 13),
  ParameterSetSubscriptionDoesNotExist((int) 14),
  TighteningIdRequestedNotFound((int) 15),
  ConnectionRejectedProtocolBusy((int) 16),
  JobIdNotPresent((int) 17),
  JobInfoSubscriptionAlreadyExists((int) 18),
  JobInfoSubscriptionDoesNotExist((int) 19),
  JobCanNotBeSet((int) 20),
  JobNotRunning((int) 21),
  NotPossibleToExecuteDynamicJobRequest((int) 22),
  JobBatchDecrementFailed((int) 23),
  NotPossibleToCreatePset((int) 24),
  ProgrammingControlNotGranted((int) 25),
  WrongToolTypeToPsetDownloadConnected((int) 26),
  ToolIsInaccessible((int) 27),
  JobAbortionIsInProgress((int) 28),
  ControllerIdNotASyncMasterOrStationController((int) 30),
  MultiSpindleStatusSubscriptionAlreadyExists((int) 31),
  MultiSpindleStatusSubscriptionDoesNotExist((int) 32),
  MultiSpindleResultSubscriptionAlreadyExists((int) 33),
  MultiSpindleResultSubscriptionDoesNotExist((int) 34),
  OtherMasterClientAlreadyConnected((int) 35),
  JobLineControlInfoSubscriptionAlreadyExists((int) 40),
  JobLineControlInfoSubscriptionDoesNotExist((int) 41),
  IdentifierInputSourceNotGranted((int) 42),
  MultipleIdentifiersWorkOrderSubscriptionAlreadyExists((int) 43),
  MultipleIdentifiersWorkOrderSubscriptionDoesNotExist((int) 44),
  StatusExternalMonitoredInputsSubscriptionAlreadyExists((int) 50),
  StatusExternalMonitoredInputsSubscriptionDoesNotExist((int) 51),
  IoDeviceNotConnected((int) 52),
  FaultyIoDeviceId((int) 53),
  ToolTagIdUnknown((int) 54),
  ToolTagIdSubscriptionAlreadyExists((int) 55),
  ToolTagIdSubscriptionDoesNotExist((int) 56),
  ToolMotorTuningFailed((int) 57),
  NoAlarmPresent((int) 58),
  ToolCurrentlyInUse((int) 59),
  NoHistogramAvailable((int) 60),
  PairingFailed((int) 61),
  PairingDenied((int) 62),
  PairingOrPairingAbortionAttemptOrWrongToolType((int) 63),
  PairingAbortionDenied((int) 64),
  PairingAbortionFailed((int) 65),
  PairingDisconnectionFailed((int) 66),
  PairingInProgressOrAlreadyDone((int) 67),
  PairingDeniedNoProgramControl((int) 68),
  UnsupportedExtraDataRevision((int) 69),
  CalibrationFailed((int) 70),
  SubscriptionAlreadyExists((int) 71),
  SubscriptionDoesNotExist((int) 72),
  SubscribedMidUnsupported((int) 73),
  SubscribedMidRevisionUnsupported((int) 74),
  RequestedMidUnsupported((int) 75),
  RequestedMidRevisionUnsupported((int) 76),
  RequestedOnSpecificDataNotSupported((int) 77),
  SubscriptionOnSpecificDataNotSupported((int) 78),
  CommandFailed((int) 79),
  AudiEmergencyStatusSubscriptionAlreadyExists((int) 80),
  AudiEmergencyStatusSubscriptionDoesNotExist((int) 81),
  AutomaticOrManualModeSubscriptionAlreadyExists((int) 82),
  AutomaticOrManualModeSubscriptionDoesNotExist((int) 83),
  TheRelayFunctionSubscriptionAlreadyExists((int) 84),
  TheRelayFunctionSubscriptionDoesNotExist((int) 85),
  TheSelectorSocketInfoSubscriptionAlreadyExists((int) 86),
  TheSelectorSocketInfoSubscriptionDoesNotExist((int) 87),
  TheDiginInfoSubscriptionAlreadyExists((int) 88),
  TheDiginInfoSubscriptionDoesNotExist((int) 89),
  LockAtBatchDoneSubscriptionAlreadyExists((int) 90),
  LockAtBatchDoneSubscriptionDoesNotExist((int) 91),
  OpenProtocolCommendsDisabled((int) 92),
  OpenProtocolCommendsDisabledSubscriptionAlreadyExists((int) 93),
  OpenProtocolCommendsDisabledSubscriptionDoesNotExist((int) 94),
  RejectRequestPowerMacsIsInManualMode((int) 95),
  RejectConnectionClientAlreadyConnected((int) 96),
  MidRevisionUnsupported((int) 97),
  ControllerInternalRequestTimeout((int) 98),
  UnknownMid((int) 99);
  private static final Map<Integer, ApplicationCommunicationError> map;

  static {
    map = new HashMap<>();
    for (ApplicationCommunicationError value : ApplicationCommunicationError.values()) {
      map.put((int) value.getValue(), value);
    }
  }

  private final int value;

  ApplicationCommunicationError(int value) {
    this.value = value;
  }

  public int getValue() {
    return value;
  }

  public static ApplicationCommunicationError enumForValue(int value) {
    return map.get(value);
  }

  public static Boolean isDefined(int value) {
    return map.containsKey(value);
  }
}
