/* ====================================================================
   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
==================================================================== */

package org.apache.poi.ss.formula.functions;

import static org.junit.jupiter.api.Assertions.assertEquals;

import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.NumberEval;
import org.apache.poi.ss.formula.eval.StringEval;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.junit.jupiter.api.Test;

/**
 *
 * Test cases for {@link TextFunction#LEFT} and {@link TextFunction#RIGHT}
 *
 */
class TestLeftRight {

    private static final NumberEval NEGATIVE_OPERAND = new NumberEval(-1.0);
    private static final StringEval ANY_STRING_VALUE = new StringEval("ANYSTRINGVALUE");


    private static ValueEval invokeLeft(ValueEval text, ValueEval operand) {
        ValueEval[] args = new ValueEval[] { text, operand };
        return TextFunction.LEFT.evaluate(args, -1, (short)-1);
    }

    private static ValueEval invokeRight(ValueEval text, ValueEval operand) {
        ValueEval[] args = new ValueEval[] { text, operand };
        return TextFunction.RIGHT.evaluate(args, -1, (short)-1);
    }

    @Test
    void testLeftRight_bug49841() {
        assertEquals(ErrorEval.VALUE_INVALID, invokeLeft(ANY_STRING_VALUE, NEGATIVE_OPERAND));
        assertEquals(ErrorEval.VALUE_INVALID, invokeRight(ANY_STRING_VALUE, NEGATIVE_OPERAND));
    }

    @Test
    void testLeftRightNegativeOperand() {
        assertEquals(ErrorEval.VALUE_INVALID, invokeRight(ANY_STRING_VALUE, NEGATIVE_OPERAND));
        assertEquals(ErrorEval.VALUE_INVALID, invokeLeft(ANY_STRING_VALUE, NEGATIVE_OPERAND));
    }
}
