/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.trino.operator.HashGenerator;
import io.trino.operator.scalar.CombineHashFunction;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.type.Type;
import io.trino.type.BlockTypeOperators;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.IntFunction;
import javax.annotation.Nullable;

public class InterpretedHashGenerator
implements HashGenerator {
    private final List<Type> hashChannelTypes;
    @Nullable
    private final int[] hashChannels;
    private final BlockTypeOperators.BlockPositionHashCode[] hashCodeOperators;

    public static InterpretedHashGenerator createPositionalWithTypes(List<Type> hashChannelTypes, BlockTypeOperators blockTypeOperators) {
        return new InterpretedHashGenerator(hashChannelTypes, null, blockTypeOperators, true);
    }

    public InterpretedHashGenerator(List<Type> hashChannelTypes, List<Integer> hashChannels, BlockTypeOperators blockTypeOperators) {
        this(hashChannelTypes, Ints.toArray((Collection)Objects.requireNonNull(hashChannels, "hashChannels is null")), blockTypeOperators);
    }

    public InterpretedHashGenerator(List<Type> hashChannelTypes, int[] hashChannels, BlockTypeOperators blockTypeOperators) {
        this(hashChannelTypes, Objects.requireNonNull(hashChannels, "hashChannels is null"), blockTypeOperators, false);
    }

    private InterpretedHashGenerator(List<Type> hashChannelTypes, @Nullable int[] hashChannels, BlockTypeOperators blockTypeOperators, boolean positional) {
        this.hashChannelTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(hashChannelTypes, "hashChannelTypes is null"));
        this.hashCodeOperators = InterpretedHashGenerator.createHashCodeOperators(hashChannelTypes, blockTypeOperators);
        Preconditions.checkArgument((this.hashCodeOperators.length == hashChannelTypes.size() ? 1 : 0) != 0);
        if (positional) {
            Preconditions.checkArgument((hashChannels == null ? 1 : 0) != 0, (Object)"hashChannels must be null");
            this.hashChannels = null;
        } else {
            Objects.requireNonNull(hashChannels, "hashChannels is null");
            Preconditions.checkArgument((hashChannels.length == this.hashCodeOperators.length ? 1 : 0) != 0);
            this.hashChannels = InterpretedHashGenerator.isPositionalChannels(hashChannels) ? null : hashChannels;
        }
    }

    @Override
    public long hashPosition(int position, Page page) {
        long result = 0L;
        for (int i = 0; i < this.hashCodeOperators.length; ++i) {
            Block block = page.getBlock(this.hashChannels == null ? i : this.hashChannels[i]);
            result = CombineHashFunction.getHash(result, this.hashCodeOperators[i].hashCodeNullSafe(block, position));
        }
        return result;
    }

    public long hashPosition(int position, IntFunction<Block> blockProvider) {
        long result = 0L;
        for (int i = 0; i < this.hashCodeOperators.length; ++i) {
            Block block = blockProvider.apply(this.hashChannels == null ? i : this.hashChannels[i]);
            result = CombineHashFunction.getHash(result, this.hashCodeOperators[i].hashCodeNullSafe(block, position));
        }
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("hashChannelTypes", this.hashChannelTypes).add("hashChannels", (Object)(this.hashChannels == null ? "<identity>" : Arrays.toString(this.hashChannels))).toString();
    }

    private static boolean isPositionalChannels(int[] hashChannels) {
        for (int i = 0; i < hashChannels.length; ++i) {
            if (hashChannels[i] == i) continue;
            return false;
        }
        return true;
    }

    private static BlockTypeOperators.BlockPositionHashCode[] createHashCodeOperators(List<Type> hashChannelTypes, BlockTypeOperators blockTypeOperators) {
        Objects.requireNonNull(hashChannelTypes, "hashChannelTypes is null");
        Objects.requireNonNull(blockTypeOperators, "blockTypeOperators is null");
        BlockTypeOperators.BlockPositionHashCode[] hashCodeOperators = new BlockTypeOperators.BlockPositionHashCode[hashChannelTypes.size()];
        for (int i = 0; i < hashCodeOperators.length; ++i) {
            hashCodeOperators[i] = blockTypeOperators.getHashCodeOperator(hashChannelTypes.get(i));
        }
        return hashCodeOperators;
    }
}

