/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.function.Description;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlNullable;
import io.trino.spi.function.SqlType;
import io.trino.type.Constraint;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import javax.annotation.Nullable;

public final class UrlFunctions {
    private static final Splitter QUERY_SPLITTER = Splitter.on((char)'&');
    private static final Splitter ARG_SPLITTER = Splitter.on((char)'=').limit(2);

    private UrlFunctions() {
    }

    @SqlNullable
    @Description(value="Extract protocol from url")
    @ScalarFunction
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice urlExtractProtocol(@SqlType(value="varchar(x)") Slice url) {
        URI uri = UrlFunctions.parseUrl(url);
        return uri == null ? null : UrlFunctions.slice(uri.getScheme());
    }

    @SqlNullable
    @Description(value="Extract host from url")
    @ScalarFunction
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice urlExtractHost(@SqlType(value="varchar(x)") Slice url) {
        URI uri = UrlFunctions.parseUrl(url);
        return uri == null ? null : UrlFunctions.slice(uri.getHost());
    }

    @SqlNullable
    @Description(value="Extract port from url")
    @ScalarFunction
    @LiteralParameters(value={"x"})
    @SqlType(value="bigint")
    public static Long urlExtractPort(@SqlType(value="varchar(x)") Slice url) {
        URI uri = UrlFunctions.parseUrl(url);
        if (uri == null || uri.getPort() < 0) {
            return null;
        }
        return uri.getPort();
    }

    @SqlNullable
    @Description(value="Extract part from url")
    @ScalarFunction
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice urlExtractPath(@SqlType(value="varchar(x)") Slice url) {
        URI uri = UrlFunctions.parseUrl(url);
        return uri == null ? null : UrlFunctions.slice(uri.getPath());
    }

    @SqlNullable
    @Description(value="Extract query from url")
    @ScalarFunction
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice urlExtractQuery(@SqlType(value="varchar(x)") Slice url) {
        URI uri = UrlFunctions.parseUrl(url);
        return uri == null ? null : UrlFunctions.slice(uri.getQuery());
    }

    @SqlNullable
    @Description(value="Extract fragment from url")
    @ScalarFunction
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice urlExtractFragment(@SqlType(value="varchar(x)") Slice url) {
        URI uri = UrlFunctions.parseUrl(url);
        return uri == null ? null : UrlFunctions.slice(uri.getFragment());
    }

    @SqlNullable
    @Description(value="Extract query parameter from url")
    @ScalarFunction
    @LiteralParameters(value={"x", "y"})
    @SqlType(value="varchar(x)")
    public static Slice urlExtractParameter(@SqlType(value="varchar(x)") Slice url, @SqlType(value="varchar(y)") Slice parameterName) {
        URI uri = UrlFunctions.parseUrl(url);
        if (uri == null || uri.getRawQuery() == null) {
            return null;
        }
        String parameter = parameterName.toStringUtf8();
        Iterable queryArgs = QUERY_SPLITTER.split((CharSequence)uri.getRawQuery());
        for (String queryArg : queryArgs) {
            Iterator arg = ARG_SPLITTER.split((CharSequence)queryArg).iterator();
            if (!((String)arg.next()).equals(parameter)) continue;
            if (arg.hasNext()) {
                return UrlFunctions.decodeUrl((String)arg.next());
            }
            return Slices.EMPTY_SLICE;
        }
        return null;
    }

    @Description(value="Escape a string for use in URL query parameter names and values")
    @ScalarFunction
    @LiteralParameters(value={"x", "y"})
    @Constraint(variable="y", expression="min(2147483647, x * 12)")
    @SqlType(value="varchar(y)")
    public static Slice urlEncode(@SqlType(value="varchar(x)") Slice value) {
        Escaper escaper = UrlEscapers.urlFormParameterEscaper();
        return UrlFunctions.slice(escaper.escape(value.toStringUtf8()));
    }

    @Description(value="Unescape a URL-encoded string")
    @ScalarFunction
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice urlDecode(@SqlType(value="varchar(x)") Slice value) {
        return UrlFunctions.decodeUrl(value.toStringUtf8());
    }

    private static Slice decodeUrl(String value) {
        try {
            return UrlFunctions.slice(URLDecoder.decode(value, StandardCharsets.UTF_8.name()));
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Throwable)e);
        }
    }

    private static Slice slice(@Nullable String s) {
        return Slices.utf8Slice((String)Strings.nullToEmpty((String)s));
    }

    @Nullable
    private static URI parseUrl(Slice url) {
        try {
            return new URI(url.toStringUtf8());
        }
        catch (URISyntaxException e) {
            return null;
        }
    }
}

