/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timestamptz;

import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.TimeZoneKey;
import io.trino.util.DateTimeZoneIndex;
import java.util.concurrent.TimeUnit;
import org.joda.time.chrono.ISOChronology;

@ScalarOperator(value=OperatorType.CAST)
public final class DateToTimestampWithTimeZoneCast {
    private DateToTimestampWithTimeZoneCast() {
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="timestamp(p) with time zone")
    public static long castToShort(ConnectorSession session, @SqlType(value="date") long date) {
        return DateTimeEncoding.packDateTimeWithZone((long)DateToTimestampWithTimeZoneCast.toEpochMillis(session, date), (TimeZoneKey)session.getTimeZoneKey());
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="timestamp(p) with time zone")
    public static LongTimestampWithTimeZone castToLong(ConnectorSession session, @SqlType(value="date") long date) {
        return LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)DateToTimestampWithTimeZoneCast.toEpochMillis(session, date), (int)0, (TimeZoneKey)session.getTimeZoneKey());
    }

    private static long toEpochMillis(ConnectorSession session, @SqlType(value="date") long date) {
        long epochMillis = TimeUnit.DAYS.toMillis(date);
        ISOChronology chronology = DateTimeZoneIndex.getChronology(session.getTimeZoneKey());
        return epochMillis - (long)chronology.getZone().getOffset(epochMillis);
    }
}

