/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.metrics;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.incubator.metrics.ExtendedLongUpDownCounterBuilder;
import io.opentelemetry.api.metrics.LongUpDownCounterBuilder;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableLongUpDownCounter;
import java.util.function.Consumer;
import org.apache.pulsar.client.impl.metrics.MetricsUtil;
import org.apache.pulsar.client.impl.metrics.Unit;

public class ObservableUpDownCounter
implements AutoCloseable {
    private final ObservableLongUpDownCounter counter;

    ObservableUpDownCounter(Meter meter, String name, Unit unit, String description, String topic, Attributes attributes, Consumer<ObservableLongMeasurement> callback) {
        LongUpDownCounterBuilder builder = meter.upDownCounterBuilder(name).setDescription(description).setUnit(unit.toString());
        if (topic != null) {
            if (builder instanceof ExtendedLongUpDownCounterBuilder) {
                ExtendedLongUpDownCounterBuilder eb = (ExtendedLongUpDownCounterBuilder)builder;
                eb.setAttributesAdvice(MetricsUtil.getDefaultAggregationLabels(attributes));
            }
            attributes = MetricsUtil.getTopicAttributes(topic, attributes);
        }
        Attributes finalAttributes = attributes;
        this.counter = builder.buildWithCallback(measurement -> {
            if (finalAttributes != null && !finalAttributes.isEmpty()) {
                callback.accept(new AttributeWrappedMeasurement((ObservableLongMeasurement)measurement, finalAttributes));
            } else {
                callback.accept((ObservableLongMeasurement)measurement);
            }
        });
    }

    @Override
    public void close() {
        this.counter.close();
    }

    private record AttributeWrappedMeasurement(ObservableLongMeasurement delegate, Attributes attributes) implements ObservableLongMeasurement
    {
        public void record(long value) {
            this.delegate.record(value, this.attributes);
        }

        public void record(long value, Attributes attributes) {
            this.delegate.record(value, this.attributes.toBuilder().putAll(attributes).build());
        }
    }
}

