/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.api.examples;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.pulsar.functions.api.Context;
import org.apache.pulsar.functions.api.Function;
import org.slf4j.Logger;

public class AsyncContextFunction
implements Function<String, CompletableFuture<Void>> {
    public CompletableFuture<Void> process(String input, Context context) {
        Logger log = context.getLogger();
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        Executors.newCachedThreadPool().submit(() -> {
            try {
                Thread.sleep(500L);
            }
            catch (Exception e) {
                log.error("Exception when Thread.sleep", (Throwable)e);
                future.completeExceptionally(e);
            }
            String inputTopics = context.getInputTopics().stream().collect(Collectors.joining(", "));
            String funcName = context.getFunctionName();
            String logMessage = String.format("A message with value of \"%s\" has arrived on one of the following topics: %s %n", input, inputTopics);
            log.info(logMessage);
            String metricName = String.format("function-%s-messages-received", funcName);
            context.recordMetric(metricName, 1.0);
            future.complete(null);
        });
        return future;
    }
}

