/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tools.common;

import com.google.common.base.Strings;
import java.io.File;
import org.apache.bookkeeper.common.annotation.InterfaceAudience;
import org.apache.bookkeeper.common.conf.ConfigurationUtil;
import org.apache.bookkeeper.common.net.ServiceURI;
import org.apache.bookkeeper.tools.common.BKFlags;
import org.apache.bookkeeper.tools.framework.Cli;
import org.apache.bookkeeper.tools.framework.CliCommand;
import org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.bookkeeper.tools.framework.CliSpec;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BKCommand<CommandFlagsT extends CliFlags>
extends CliCommand<BKFlags, CommandFlagsT> {
    private static final Logger log = LoggerFactory.getLogger(BKCommand.class);

    protected BKCommand(CliSpec<CommandFlagsT> spec) {
        super(spec);
    }

    @Override
    public Boolean apply(BKFlags globalFlags, String[] args) {
        CliSpec<CliFlags> newSpec = CliSpec.newBuilder(this.spec).withRunFunc(cmdFlags -> this.apply(globalFlags, cmdFlags)).build();
        return 0 == Cli.runCli(newSpec, args);
    }

    @InterfaceAudience.Private
    public int apply(String commandName, CompositeConfiguration conf, String[] args) {
        CliSpec<CliFlags> newSpec = CliSpec.newBuilder(this.spec).withName(commandName).withRunFunc(cmdFlags -> this.apply(null, conf, new BKFlags(), cmdFlags)).build();
        return Cli.runCli(newSpec, args);
    }

    protected boolean apply(BKFlags bkFlags, CommandFlagsT cmdFlags) {
        ServiceURI serviceURI = null;
        if (null != bkFlags.serviceUri && !this.acceptServiceUri(serviceURI = ServiceURI.create((String)bkFlags.serviceUri))) {
            log.error("Unresolvable service uri by command '{}' : {}", (Object)this.path(), (Object)bkFlags.serviceUri);
            return false;
        }
        CompositeConfiguration conf = new CompositeConfiguration();
        if (!Strings.isNullOrEmpty((String)bkFlags.configFile)) {
            try {
                PropertiesConfiguration loadedConf = ConfigurationUtil.newConfiguration(c -> c.propertiesBuilder(new File(bkFlags.configFile)));
                conf.addConfiguration((Configuration)loadedConf);
            }
            catch (ConfigurationException e) {
                log.error("Malformed configuration file : {}", (Object)bkFlags.configFile, (Object)e);
                throw new IllegalArgumentException(e);
            }
        }
        return this.apply(serviceURI, conf, bkFlags, cmdFlags);
    }

    protected boolean acceptServiceUri(ServiceURI serviceURI) {
        return true;
    }

    protected abstract boolean apply(ServiceURI var1, CompositeConfiguration var2, BKFlags var3, CommandFlagsT var4);
}

