/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger;

import io.netty.buffer.ByteBuf;
import org.apache.bookkeeper.common.annotation.InterfaceAudience;
import org.apache.bookkeeper.common.annotation.InterfaceStability;
import org.apache.bookkeeper.mledger.EntryReadCountHandler;
import org.apache.bookkeeper.mledger.Position;
import org.apache.pulsar.common.api.proto.MessageMetadata;
import org.apache.pulsar.common.protocol.Commands;

@InterfaceAudience.LimitedPrivate
@InterfaceStability.Stable
public interface Entry {
    public byte[] getData();

    public byte[] getDataAndRelease();

    public int getLength();

    public ByteBuf getDataBuffer();

    public Position getPosition();

    public long getLedgerId();

    public long getEntryId();

    public boolean release();

    default public EntryReadCountHandler getReadCountHandler() {
        return null;
    }

    default public boolean hasExpectedReads() {
        EntryReadCountHandler readCountHandler = this.getReadCountHandler();
        if (readCountHandler != null) {
            return readCountHandler.hasExpectedReads();
        }
        return false;
    }

    default public boolean matchesPosition(Position position) {
        return position != null && position.compareTo(this.getLedgerId(), this.getEntryId()) == 0;
    }

    default public MessageMetadata getMessageMetadata() {
        return null;
    }

    default public long getEntryTimestamp() {
        return Commands.peekBrokerEntryMetadataToLong((ByteBuf)this.getDataBuffer(), brokerEntryMetadata -> {
            if (brokerEntryMetadata != null && brokerEntryMetadata.hasBrokerTimestamp()) {
                return brokerEntryMetadata.getBrokerTimestamp();
            }
            MessageMetadata messageMetadata = this.getMessageMetadata();
            if (messageMetadata == null) {
                messageMetadata = Commands.peekMessageMetadata((ByteBuf)this.getDataBuffer(), null, (long)-1L);
            }
            return messageMetadata.getPublishTime();
        });
    }
}

