/*
 * Decompiled with CFR 0.152.
 */
package io.oxia.client.grpc;

import com.google.common.annotations.VisibleForTesting;
import io.grpc.internal.BackoffPolicy;
import io.oxia.client.ClientConfig;
import io.oxia.client.grpc.OxiaStub;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;

public class OxiaStubManager
implements AutoCloseable {
    @VisibleForTesting
    final Map<Key, OxiaStub> stubs = new ConcurrentHashMap<Key, OxiaStub>();
    private final BackoffPolicy.Provider backoffProvider;
    private final int maxConnectionPerNode;
    private final ClientConfig clientConfig;

    public OxiaStubManager(ClientConfig clientConfig, BackoffPolicy.Provider backoffProvider) {
        this.backoffProvider = backoffProvider;
        this.clientConfig = clientConfig;
        this.maxConnectionPerNode = clientConfig.maxConnectionPerNode();
    }

    public OxiaStub getStub(String address) {
        int random = ThreadLocalRandom.current().nextInt();
        int modKey = random % this.maxConnectionPerNode;
        if (modKey < 0) {
            modKey += this.maxConnectionPerNode;
        }
        return this.stubs.computeIfAbsent(new Key(address, modKey), key -> new OxiaStub(key.address, this.clientConfig, this.backoffProvider));
    }

    @Override
    public void close() throws Exception {
        for (OxiaStub stub : this.stubs.values()) {
            stub.close();
        }
    }

    record Key(String address, int random) {
    }
}

