/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.service;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.contextenricher.RangerContextEnricher;
import org.apache.ranger.plugin.policyengine.RangerSecurityZoneMatcher;
import org.apache.ranger.plugin.util.RangerRoles;
import org.apache.ranger.plugin.util.RangerRolesUtil;
import org.apache.ranger.plugin.util.RangerUserStore;
import org.apache.ranger.plugin.util.RangerUserStoreUtil;

public class RangerAuthContext {
    private final Map<RangerContextEnricher, Object> requestContextEnrichers;
    private final RangerSecurityZoneMatcher zoneMatcher;
    private RangerRolesUtil rolesUtil;
    private RangerUserStoreUtil userStoreUtil;

    public RangerAuthContext(Map<RangerContextEnricher, Object> requestContextEnrichers, RangerSecurityZoneMatcher zoneMatcher, RangerRoles roles, RangerUserStore userStore) {
        this.requestContextEnrichers = requestContextEnrichers != null ? requestContextEnrichers : new ConcurrentHashMap();
        this.zoneMatcher = zoneMatcher;
        this.setRoles(roles);
        this.setUserStore(userStore);
    }

    public Map<RangerContextEnricher, Object> getRequestContextEnrichers() {
        return this.requestContextEnrichers;
    }

    public RangerSecurityZoneMatcher getZoneMatcher() {
        return this.zoneMatcher;
    }

    public void addOrReplaceRequestContextEnricher(RangerContextEnricher enricher, Object database) {
        this.requestContextEnrichers.put(enricher, database != null ? database : enricher);
        if (database instanceof RangerUserStore) {
            this.setUserStore((RangerUserStore)database);
        }
    }

    public void cleanupRequestContextEnricher(RangerContextEnricher enricher) {
        this.requestContextEnrichers.remove(enricher);
    }

    public void setRoles(RangerRoles roles) {
        this.rolesUtil = new RangerRolesUtil(roles);
    }

    public Set<String> getRolesForUserAndGroups(String user, Set<String> groups) {
        Object userRoles;
        RangerRolesUtil rolesUtil = this.rolesUtil;
        Map<String, Set<String>> userRoleMapping = rolesUtil.getUserRoleMapping();
        Map<String, Set<String>> groupRoleMapping = rolesUtil.getGroupRoleMapping();
        HashSet<String> allRoles = new HashSet<String>();
        if (MapUtils.isNotEmpty(userRoleMapping) && StringUtils.isNotEmpty((String)user) && CollectionUtils.isNotEmpty(userRoles = userRoleMapping.get(user))) {
            allRoles.addAll((Collection<String>)userRoles);
        }
        if (MapUtils.isNotEmpty(groupRoleMapping)) {
            Set<String> publicGroupRoles;
            if (CollectionUtils.isNotEmpty(groups)) {
                for (String group : groups) {
                    Set<String> groupRoles = groupRoleMapping.get(group);
                    if (!CollectionUtils.isNotEmpty(groupRoles)) continue;
                    allRoles.addAll(groupRoles);
                }
            }
            if (CollectionUtils.isNotEmpty(publicGroupRoles = groupRoleMapping.get("public"))) {
                allRoles.addAll(publicGroupRoles);
            }
        }
        return allRoles;
    }

    public long getRoleVersion() {
        return this.rolesUtil.getRoleVersion();
    }

    public RangerRolesUtil getRangerRolesUtil() {
        return this.rolesUtil;
    }

    public long getUserStoreVersion() {
        return this.userStoreUtil.getUserStoreVersion();
    }

    public RangerUserStoreUtil getUserStoreUtil() {
        return this.userStoreUtil;
    }

    public void setUserStore(RangerUserStore userStore) {
        this.userStoreUtil = new RangerUserStoreUtil(userStore);
    }
}

