/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.kafka.authorizer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.authorization.kafka.authorizer.RangerKafkaAuditHandler;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResourceImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerAccessResultProcessor;
import org.apache.ranger.plugin.service.RangerBasePlugin;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerKafkaAuthorizer
implements Authorizer {
    private static final Logger logger = LoggerFactory.getLogger(RangerKafkaAuthorizer.class);
    private static final Logger PERF_KAFKAAUTH_REQUEST_LOG = RangerPerfTracer.getPerfLogger((String)"kafkaauth.request");
    public static final String ACCESS_TYPE_ALTER_CONFIGS = "alter_configs";
    public static final String KEY_TOPIC = "topic";
    public static final String KEY_CLUSTER = "cluster";
    public static final String KEY_CONSUMER_GROUP = "consumergroup";
    public static final String KEY_TRANSACTIONALID = "transactionalid";
    public static final String KEY_DELEGATIONTOKEN = "delegationtoken";
    public static final String ACCESS_TYPE_READ = "consume";
    public static final String ACCESS_TYPE_WRITE = "publish";
    public static final String ACCESS_TYPE_CREATE = "create";
    public static final String ACCESS_TYPE_DELETE = "delete";
    public static final String ACCESS_TYPE_CONFIGURE = "configure";
    public static final String ACCESS_TYPE_DESCRIBE = "describe";
    public static final String ACCESS_TYPE_DESCRIBE_CONFIGS = "describe_configs";
    public static final String ACCESS_TYPE_CLUSTER_ACTION = "cluster_action";
    public static final String ACCESS_TYPE_IDEMPOTENT_WRITE = "idempotent_write";
    private static volatile RangerBasePlugin rangerPlugin = null;
    RangerKafkaAuditHandler auditHandler = null;

    private static String mapToRangerAccessType(AclOperation operation) {
        switch (operation) {
            case READ: {
                return ACCESS_TYPE_READ;
            }
            case WRITE: {
                return ACCESS_TYPE_WRITE;
            }
            case ALTER: {
                return ACCESS_TYPE_CONFIGURE;
            }
            case DESCRIBE: {
                return ACCESS_TYPE_DESCRIBE;
            }
            case CLUSTER_ACTION: {
                return ACCESS_TYPE_CLUSTER_ACTION;
            }
            case CREATE: {
                return ACCESS_TYPE_CREATE;
            }
            case DELETE: {
                return ACCESS_TYPE_DELETE;
            }
            case DESCRIBE_CONFIGS: {
                return ACCESS_TYPE_DESCRIBE_CONFIGS;
            }
            case ALTER_CONFIGS: {
                return ACCESS_TYPE_ALTER_CONFIGS;
            }
            case IDEMPOTENT_WRITE: {
                return ACCESS_TYPE_IDEMPOTENT_WRITE;
            }
        }
        return null;
    }

    private static String mapToResourceType(ResourceType resourceType) {
        switch (resourceType) {
            case TOPIC: {
                return KEY_TOPIC;
            }
            case CLUSTER: {
                return KEY_CLUSTER;
            }
            case GROUP: {
                return KEY_CONSUMER_GROUP;
            }
            case TRANSACTIONAL_ID: {
                return KEY_TRANSACTIONALID;
            }
            case DELEGATION_TOKEN: {
                return KEY_DELEGATIONTOKEN;
            }
        }
        return null;
    }

    private static RangerAccessResourceImpl createRangerAccessResource(String resourceTypeKey, String resourceName) {
        RangerAccessResourceImpl rangerResource = new RangerAccessResourceImpl();
        rangerResource.setValue(resourceTypeKey, (Object)resourceName);
        return rangerResource;
    }

    private static RangerAccessRequestImpl createRangerAccessRequest(String userName, Set<String> userGroups, String ip, Date eventTime, String resourceTypeKey, String resourceName, String accessType) {
        RangerAccessRequestImpl rangerRequest = new RangerAccessRequestImpl();
        rangerRequest.setResource((RangerAccessResource)RangerKafkaAuthorizer.createRangerAccessResource(resourceTypeKey, resourceName));
        rangerRequest.setUser(userName);
        rangerRequest.setUserGroups(userGroups);
        rangerRequest.setClientIPAddress(ip);
        rangerRequest.setAccessTime(eventTime);
        rangerRequest.setAccessType(accessType);
        rangerRequest.setAction(accessType);
        rangerRequest.setRequestData(resourceName);
        return rangerRequest;
    }

    private static List<AuthorizationResult> denyAll(List<Action> actions) {
        return actions.stream().map(a -> AuthorizationResult.DENIED).collect(Collectors.toList());
    }

    private static List<AuthorizationResult> mapResults(List<Action> actions, Collection<RangerAccessResult> results) {
        if (CollectionUtils.isEmpty(results)) {
            logger.error("Ranger Plugin returned null or empty. Returning Denied for all");
            return RangerKafkaAuthorizer.denyAll(actions);
        }
        return results.stream().map(r -> r != null && r.getIsAllowed() ? AuthorizationResult.ALLOWED : AuthorizationResult.DENIED).collect(Collectors.toList());
    }

    private static String toString(AuthorizableRequestContext requestContext) {
        return requestContext == null ? null : String.format("AuthorizableRequestContext{principal=%s, clientAddress=%s, clientId=%s}", requestContext.principal(), requestContext.clientAddress(), requestContext.clientId());
    }

    public void close() {
        logger.info("close() called on authorizer.");
        try {
            if (rangerPlugin != null) {
                rangerPlugin.cleanup();
            }
        }
        catch (Throwable t) {
            logger.error("Error closing RangerPlugin.", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void configure(Map<String, ?> configs) {
        RangerBasePlugin me = rangerPlugin;
        if (me != null) return;
        Class<RangerKafkaAuthorizer> clazz = RangerKafkaAuthorizer.class;
        synchronized (RangerKafkaAuthorizer.class) {
            me = rangerPlugin;
            if (me != null) return;
            try {
                Object jaasContext = configs.get("ranger.jaas.context");
                String listenerName = jaasContext instanceof String && StringUtils.isNotEmpty((String)((String)jaasContext)) ? (String)jaasContext : SecurityProtocol.SASL_PLAINTEXT.name();
                String saslMechanism = "GSSAPI";
                JaasContext context = JaasContext.loadServerContext((ListenerName)new ListenerName(listenerName), (String)"GSSAPI", configs);
                MiscUtil.setUGIFromJAASConfig((String)context.name());
                UserGroupInformation loginUser = MiscUtil.getUGILoginUser();
                logger.info("LoginUser={}", (Object)loginUser);
            }
            catch (Throwable t) {
                logger.error("Error getting principal.", t);
            }
            rangerPlugin = new RangerBasePlugin("kafka", "kafka");
            logger.info("Calling plugin.init()");
            rangerPlugin.init();
            this.auditHandler = new RangerKafkaAuditHandler();
            rangerPlugin.setResultProcessor((RangerAccessResultProcessor)this.auditHandler);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public Map<Endpoint, ? extends CompletionStage<Void>> start(AuthorizerServerInfo serverInfo) {
        return serverInfo.endpoints().stream().collect(Collectors.toMap(endpoint -> endpoint, endpoint -> CompletableFuture.completedFuture(null), (a, b) -> b));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AuthorizationResult> authorize(AuthorizableRequestContext requestContext, List<Action> actions) {
        if (rangerPlugin == null) {
            MiscUtil.logErrorMessageByInterval((Logger)logger, (String)"Authorizer is still not initialized");
            return RangerKafkaAuthorizer.denyAll(actions);
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled((Logger)PERF_KAFKAAUTH_REQUEST_LOG)) {
            perf = RangerPerfTracer.getPerfTracer((Logger)PERF_KAFKAAUTH_REQUEST_LOG, (String)("RangerKafkaAuthorizer.authorize(actions=" + actions + ")"));
        }
        try {
            List<AuthorizationResult> list = this.wrappedAuthorization(requestContext, actions);
            return list;
        }
        finally {
            RangerPerfTracer.log(perf);
        }
    }

    private List<AuthorizationResult> wrappedAuthorization(AuthorizableRequestContext requestContext, List<Action> actions) {
        if (CollectionUtils.isEmpty(actions)) {
            return Collections.emptyList();
        }
        String userName = requestContext.principal() == null ? null : requestContext.principal().getName();
        Set userGroups = MiscUtil.getGroupsForRequestUser((String)userName);
        String hostAddress = requestContext.clientAddress() == null ? null : requestContext.clientAddress().getHostAddress();
        String ip = StringUtils.isNotEmpty((String)hostAddress) && hostAddress.charAt(0) == '/' ? hostAddress.substring(1) : hostAddress;
        Date eventTime = new Date();
        ArrayList<RangerAccessRequest> rangerRequests = new ArrayList<RangerAccessRequest>();
        for (Action action : actions) {
            String accessType = RangerKafkaAuthorizer.mapToRangerAccessType(action.operation());
            if (accessType == null) {
                MiscUtil.logErrorMessageByInterval((Logger)logger, (String)("Unsupported access type, requestContext=" + RangerKafkaAuthorizer.toString(requestContext) + ", actions=" + actions + ", operation=" + action.operation()));
                return RangerKafkaAuthorizer.denyAll(actions);
            }
            String resourceTypeKey = RangerKafkaAuthorizer.mapToResourceType(action.resourcePattern().resourceType());
            if (resourceTypeKey == null) {
                MiscUtil.logErrorMessageByInterval((Logger)logger, (String)("Unsupported resource type, requestContext=" + RangerKafkaAuthorizer.toString(requestContext) + ", actions=" + actions + ", resourceType=" + action.resourcePattern().resourceType()));
                return RangerKafkaAuthorizer.denyAll(actions);
            }
            RangerAccessRequestImpl rangerAccessRequest = RangerKafkaAuthorizer.createRangerAccessRequest(userName, userGroups, ip, eventTime, resourceTypeKey, action.resourcePattern().name(), accessType);
            rangerRequests.add((RangerAccessRequest)rangerAccessRequest);
        }
        Collection<RangerAccessResult> results = this.callRangerPlugin(rangerRequests);
        List<AuthorizationResult> authorizationResults = RangerKafkaAuthorizer.mapResults(actions, results);
        logger.debug("rangerRequests={}, return={}", rangerRequests, authorizationResults);
        return authorizationResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<RangerAccessResult> callRangerPlugin(List<RangerAccessRequest> rangerRequests) {
        try {
            Collection collection = rangerPlugin.isAccessAllowed(rangerRequests);
            return collection;
        }
        catch (Throwable t) {
            logger.error("Error while calling isAccessAllowed(). requests={}", rangerRequests, (Object)t);
            Collection<RangerAccessResult> collection = null;
            return collection;
        }
        finally {
            this.auditHandler.flushAudit();
        }
    }

    public List<? extends CompletionStage<AclCreateResult>> createAcls(AuthorizableRequestContext requestContext, List<AclBinding> aclBindings) {
        logger.error("createAcls is not supported by Ranger for Kafka");
        return aclBindings.stream().map(ab -> {
            CompletableFuture completableFuture = new CompletableFuture();
            completableFuture.completeExceptionally(new UnsupportedOperationException("createAcls is not supported by Ranger for Kafka"));
            return completableFuture;
        }).collect(Collectors.toList());
    }

    public List<? extends CompletionStage<AclDeleteResult>> deleteAcls(AuthorizableRequestContext requestContext, List<AclBindingFilter> aclBindingFilters) {
        logger.error("deleteAcls is not supported by Ranger for Kafka");
        return aclBindingFilters.stream().map(ab -> {
            CompletableFuture completableFuture = new CompletableFuture();
            completableFuture.completeExceptionally(new UnsupportedOperationException("deleteAcls is not supported by Ranger for Kafka"));
            return completableFuture;
        }).collect(Collectors.toList());
    }

    public AuthorizationResult authorizeByResourceType(AuthorizableRequestContext requestContext, AclOperation op, ResourceType resourceType) {
        SecurityUtils.authorizeByResourceTypeCheckArgs((AclOperation)op, (ResourceType)resourceType);
        logger.debug("authorizeByResourceType call is not supported by Ranger for Kafka yet");
        return AuthorizationResult.DENIED;
    }

    public Iterable<AclBinding> acls(AclBindingFilter filter) {
        logger.error("(getting) acls is not supported by Ranger for Kafka");
        throw new UnsupportedOperationException("(getting) acls is not supported by Ranger for Kafka");
    }
}

