/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key;

import java.io.IOException;
import java.security.Key;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.RangerGoogleCloudHSMProvider;
import org.apache.hadoop.crypto.key.RangerKMSDB;
import org.apache.hadoop.crypto.key.RangerKeyStore;
import org.apache.hadoop.crypto.key.RangerKeyStoreProvider;
import org.apache.hadoop.crypto.key.RangerMasterKey;
import org.apache.ranger.entity.XXRangerKeyStore;
import org.apache.ranger.kms.dao.DaoManager;

public class MigrateDBMKeyToGCP {
    private static final String ENCRYPTION_KEY = "ranger.db.encrypt.key.password";
    private static RangerGoogleCloudHSMProvider rangerGcpProvider;
    private RangerKeyStore dbStore;

    public static void main(String[] args) throws Exception {
        if (args == null || args.length != 5) {
            System.err.println("Invalid number of parameters found.");
            MigrateDBMKeyToGCP.showUsage();
            System.exit(1);
        } else {
            Configuration conf = RangerKeyStoreProvider.getDBKSConf();
            String gcpMasterKeyName = args[0];
            String gcpProjectId = args[1];
            String gcpKeyRingId = args[2];
            String gcpKeyRingLocationId = args[3];
            String pathOfJsonCredFile = args[4];
            if (conf != null) {
                conf.set("ranger.kms.gcp.masterkey.name", gcpMasterKeyName);
                conf.set("ranger.kms.gcp.project.id", gcpProjectId);
                conf.set("ranger.kms.gcp.keyring.id", gcpKeyRingId);
                conf.set("ranger.kms.gcp.location.id", gcpKeyRingLocationId);
                conf.set("ranger.kms.gcp.cred.file", pathOfJsonCredFile);
                rangerGcpProvider = new RangerGoogleCloudHSMProvider(conf);
                rangerGcpProvider.onInitialization();
                boolean result = new MigrateDBMKeyToGCP().doExportMKToGcp(conf, gcpMasterKeyName);
                if (result) {
                    System.out.println("Master Key from Ranger KMS DB has been successfully migrated to GCP.");
                    System.exit(0);
                } else {
                    System.out.println("Migration of Master Key from Ranger KMS DB to GCP has been unsuccessful.");
                    System.exit(1);
                }
            } else {
                System.out.println("Migration of Master Key from Ranger KMS DB to GCP failed, Error - Configuration is null.");
                System.exit(1);
            }
        }
    }

    private boolean doExportMKToGcp(Configuration conf, String masterKeyName) {
        try {
            String mKeyPass = conf.get(ENCRYPTION_KEY);
            if (mKeyPass == null || mKeyPass.trim().equals("") || mKeyPass.trim().equals("_") || mKeyPass.trim().equals("crypted")) {
                throw new IOException("Master Key Jceks does not exists");
            }
            RangerKMSDB rangerkmsDb = new RangerKMSDB(conf);
            DaoManager daoManager = rangerkmsDb.getDaoManager();
            System.out.println("Creating masterkey with the name - " + masterKeyName);
            boolean gcpMKSuccess = rangerGcpProvider.generateMasterKey(null);
            if (gcpMKSuccess) {
                System.out.println("Masterkey with the name '" + masterKeyName + "' created successfully on Google Cloud KMS.");
                this.dbStore = new RangerKeyStore(daoManager, false, rangerGcpProvider);
                RangerMasterKey rangerMasterKey = new RangerMasterKey(daoManager);
                char[] mkey = rangerMasterKey.getMasterKey(mKeyPass).toCharArray();
                ArrayList<XXRangerKeyStore> rangerKeyStoreList = new ArrayList<XXRangerKeyStore>();
                this.dbStore.engineLoad(null, mkey);
                Enumeration<String> e = this.dbStore.engineAliases();
                String alias = null;
                while (e.hasMoreElements()) {
                    alias = e.nextElement();
                    Key key = this.dbStore.engineGetKey(alias, mkey);
                    XXRangerKeyStore xxRangerKeyStore = this.dbStore.convertKeysBetweenRangerKMSAndGCP(alias, key, rangerGcpProvider);
                    rangerKeyStoreList.add(xxRangerKeyStore);
                }
                if (rangerKeyStoreList != null && !rangerKeyStoreList.isEmpty()) {
                    for (XXRangerKeyStore rangerKeyStore : rangerKeyStoreList) {
                        this.dbStore.dbOperationStore(rangerKeyStore);
                    }
                }
                return true;
            }
            return false;
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to migrate Master key from Ranger KMS DB to GCP ", t);
        }
    }

    private static void showUsage() {
        System.err.println("USAGE: java " + MigrateDBMKeyToGCP.class.getName() + " <gcpMasterKeyName> <gcpProjectName> <gcpKeyRingName> <gcpKeyRingLocationName> <pathOfJsonCredFile> ");
    }
}

