/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.ozone.authorizer;

import java.util.Date;
import java.util.Set;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.IOzoneObj;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.security.acl.RequestContext;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.thirdparty.com.google.common.collect.Sets;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.plugin.audit.RangerDefaultAuditHandler;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResourceImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerAccessResultProcessor;
import org.apache.ranger.plugin.service.RangerBasePlugin;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerOzoneAuthorizer
implements IAccessAuthorizer {
    public static final String ACCESS_TYPE_READ = "read";
    public static final String ACCESS_TYPE_WRITE = "write";
    public static final String ACCESS_TYPE_CREATE = "create";
    public static final String ACCESS_TYPE_LIST = "list";
    public static final String ACCESS_TYPE_DELETE = "delete";
    public static final String ACCESS_TYPE_READ_ACL = "read_acl";
    public static final String ACCESS_TYPE_WRITE_ACL = "write_acl";
    public static final String KEY_RESOURCE_VOLUME = "volume";
    public static final String KEY_RESOURCE_BUCKET = "bucket";
    public static final String KEY_RESOURCE_KEY = "key";
    private static final Logger PERF_OZONEAUTH_REQUEST_LOG = RangerPerfTracer.getPerfLogger((String)"ozoneauth.request");
    private static final Logger LOG = LoggerFactory.getLogger(RangerOzoneAuthorizer.class);
    private static volatile RangerBasePlugin rangerPlugin = null;
    RangerDefaultAuditHandler auditHandler = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RangerOzoneAuthorizer() {
        RangerBasePlugin plugin = rangerPlugin;
        if (plugin != null) return;
        Class<RangerOzoneAuthorizer> clazz = RangerOzoneAuthorizer.class;
        synchronized (RangerOzoneAuthorizer.class) {
            plugin = rangerPlugin;
            if (plugin != null) return;
            plugin = new RangerBasePlugin("ozone", "ozone");
            plugin.init();
            this.auditHandler = new RangerDefaultAuditHandler();
            plugin.setResultProcessor((RangerAccessResultProcessor)this.auditHandler);
            rangerPlugin = plugin;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public boolean checkAccess(IOzoneObj ozoneObject, RequestContext context) {
        boolean returnValue = false;
        if (ozoneObject == null) {
            LOG.error("Ozone object is null!!");
            return returnValue;
        }
        OzoneObj ozoneObj = (OzoneObj)ozoneObject;
        UserGroupInformation ugi = context.getClientUgi();
        IAccessAuthorizer.ACLType operation = context.getAclRights();
        String resource = ozoneObj.getPath();
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerOzoneAuthorizer.checkAccess with operation = " + operation + ", resource = " + resource + ", store type = " + OzoneObj.StoreType.values() + ", ugi = " + ugi + ", ip = " + context.getIp() + ", resourceType = " + ozoneObj.getResourceType() + ")");
        }
        if (rangerPlugin == null) {
            MiscUtil.logErrorMessageByInterval((Logger)LOG, (String)"Authorizer is still not initialized");
            return returnValue;
        }
        if (ozoneObj.getStoreType() == OzoneObj.StoreType.S3 && ozoneObj.getResourceType() == OzoneObj.ResourceType.VOLUME) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("If store type is s3 and resource is volume, then we allow it by default!  Returning true");
            }
            LOG.warn("Allowing access by default since source type is S3 and resource type is Volume!!");
            return true;
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled((Logger)PERF_OZONEAUTH_REQUEST_LOG)) {
            perf = RangerPerfTracer.getPerfTracer((Logger)PERF_OZONEAUTH_REQUEST_LOG, (String)("RangerOzoneAuthorizer.authorize(resource=" + resource + ")"));
        }
        Date eventTime = new Date();
        String accessType = this.mapToRangerAccessType(operation);
        if (accessType == null) {
            MiscUtil.logErrorMessageByInterval((Logger)LOG, (String)("Unsupported access type. operation=" + operation));
            LOG.error("Unsupported access type. operation=" + operation + ", resource=" + resource);
            return returnValue;
        }
        String action = accessType;
        String clusterName = rangerPlugin.getClusterName();
        RangerAccessRequestImpl rangerRequest = new RangerAccessRequestImpl();
        rangerRequest.setUser(ugi.getShortUserName());
        rangerRequest.setUserGroups((Set)Sets.newHashSet((Object[])ugi.getGroupNames()));
        rangerRequest.setClientIPAddress(context.getIp().getHostAddress());
        rangerRequest.setRemoteIPAddress(context.getIp().getHostAddress());
        rangerRequest.setAccessTime(eventTime);
        RangerAccessResourceImpl rangerResource = new RangerAccessResourceImpl();
        rangerResource.setOwnerUser(context.getOwnerName());
        rangerRequest.setResource((RangerAccessResource)rangerResource);
        rangerRequest.setAccessType(accessType);
        rangerRequest.setAction(action);
        rangerRequest.setRequestData(resource);
        rangerRequest.setClusterName(clusterName);
        if (ozoneObj.getResourceType() == OzoneObj.ResourceType.VOLUME) {
            rangerResource.setValue(KEY_RESOURCE_VOLUME, (Object)ozoneObj.getVolumeName());
        } else if (ozoneObj.getResourceType() == OzoneObj.ResourceType.BUCKET || ozoneObj.getResourceType() == OzoneObj.ResourceType.KEY) {
            if (ozoneObj.getStoreType() == OzoneObj.StoreType.S3) {
                rangerResource.setValue(KEY_RESOURCE_VOLUME, (Object)"s3Vol");
            } else {
                rangerResource.setValue(KEY_RESOURCE_VOLUME, (Object)ozoneObj.getVolumeName());
            }
            rangerResource.setValue(KEY_RESOURCE_BUCKET, (Object)ozoneObj.getBucketName());
            if (ozoneObj.getResourceType() == OzoneObj.ResourceType.KEY) {
                rangerResource.setValue(KEY_RESOURCE_KEY, (Object)ozoneObj.getKeyName());
            }
        } else {
            LOG.error("Unsupported resource = " + resource);
            MiscUtil.logErrorMessageByInterval((Logger)LOG, (String)("Unsupported resource type " + ozoneObj.getResourceType() + " for resource = " + resource + ", request=" + rangerRequest));
            return returnValue;
        }
        try {
            RangerAccessResult result = rangerPlugin.isAccessAllowed((RangerAccessRequest)rangerRequest);
            if (result == null) {
                LOG.error("Ranger Plugin returned null. Returning false");
            } else {
                returnValue = result.getIsAllowed();
            }
        }
        catch (Throwable t) {
            LOG.error("Error while calling isAccessAllowed(). request=" + rangerRequest, t);
        }
        RangerPerfTracer.log((RangerPerfTracer)perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("rangerRequest=" + rangerRequest + ", return=" + returnValue);
        }
        return returnValue;
    }

    private String mapToRangerAccessType(IAccessAuthorizer.ACLType operation) {
        String rangerAccessType = null;
        switch (operation) {
            case READ: {
                rangerAccessType = ACCESS_TYPE_READ;
                break;
            }
            case WRITE: {
                rangerAccessType = ACCESS_TYPE_WRITE;
                break;
            }
            case CREATE: {
                rangerAccessType = ACCESS_TYPE_CREATE;
                break;
            }
            case DELETE: {
                rangerAccessType = ACCESS_TYPE_DELETE;
                break;
            }
            case LIST: {
                rangerAccessType = ACCESS_TYPE_LIST;
                break;
            }
            case READ_ACL: {
                rangerAccessType = ACCESS_TYPE_READ_ACL;
                break;
            }
            case WRITE_ACL: {
                rangerAccessType = ACCESS_TYPE_WRITE_ACL;
            }
        }
        return rangerAccessType;
    }
}

