/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.nifi.registry;

import java.util.HashMap;
import java.util.List;
import org.apache.ranger.plugin.service.RangerBaseService;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.services.nifi.registry.client.NiFiRegistryClient;
import org.apache.ranger.services.nifi.registry.client.NiFiRegistryConnectionMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerServiceNiFiRegistry
extends RangerBaseService {
    private static final Logger LOG = LoggerFactory.getLogger(RangerServiceNiFiRegistry.class);

    public HashMap<String, Object> validateConfig() throws Exception {
        HashMap<String, Object> ret;
        String serviceName = this.getServiceName();
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerServiceNiFiRegistry.validateConfig Service: (" + serviceName + " )");
        }
        if (this.configs != null) {
            try {
                ret = NiFiRegistryConnectionMgr.connectionTest(serviceName, this.configs);
            }
            catch (Exception e) {
                LOG.error("<== RangerServiceNiFiRegistry.validateConfig Error:", (Throwable)e);
                throw e;
            }
        } else {
            throw new IllegalStateException("No Configuration found");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerServiceNiFiRegistry.validateConfig Response : (" + ret + " )");
        }
        return ret;
    }

    public List<String> lookupResource(ResourceLookupContext context) throws Exception {
        NiFiRegistryClient client = NiFiRegistryConnectionMgr.getNiFiRegistryClient(this.serviceName, this.configs);
        return client.getResources(context);
    }
}

