/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.yarn.authorizer;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.security.AccessRequest;
import org.apache.hadoop.yarn.security.Permission;
import org.apache.hadoop.yarn.security.YarnAuthorizationProvider;
import org.apache.ranger.plugin.classloader.RangerPluginClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerYarnAuthorizer
extends YarnAuthorizationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(RangerYarnAuthorizer.class);
    private static final String RANGER_PLUGIN_TYPE = "yarn";
    private static final String RANGER_YARN_AUTHORIZER_IMPL_CLASSNAME = "org.apache.ranger.authorization.yarn.authorizer.RangerYarnAuthorizer";
    private YarnAuthorizationProvider yarnAuthorizationProviderImpl = null;
    private RangerPluginClassLoader rangerPluginClassLoader = null;

    public RangerYarnAuthorizer() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerYarnAuthorizer.RangerYarnAuthorizer()");
        }
        this.init();
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerYarnAuthorizer.RangerYarnAuthorizer()");
        }
    }

    private void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerYarnAuthorizer.init()");
        }
        try {
            this.rangerPluginClassLoader = RangerPluginClassLoader.getInstance((String)RANGER_PLUGIN_TYPE, ((Object)((Object)this)).getClass());
            Class<?> cls = Class.forName(RANGER_YARN_AUTHORIZER_IMPL_CLASSNAME, true, (ClassLoader)this.rangerPluginClassLoader);
            this.activatePluginClassLoader();
            this.yarnAuthorizationProviderImpl = (YarnAuthorizationProvider)cls.newInstance();
        }
        catch (Exception e) {
            LOG.error("Error Enabling RangerYarnPlugin", (Throwable)e);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerYarnAuthorizer.init()");
        }
    }

    public void init(Configuration conf) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerYarnAuthorizer.init()");
        }
        try {
            this.activatePluginClassLoader();
            this.yarnAuthorizationProviderImpl.init(conf);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerYarnAuthorizer.start()");
        }
    }

    public boolean checkPermission(AccessRequest accessRequest) {
        boolean ret = false;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerYarnAuthorizer.checkPermission()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.yarnAuthorizationProviderImpl.checkPermission(accessRequest);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerYarnAuthorizer.checkPermission()");
        }
        return ret;
    }

    public void setPermission(List<Permission> permissions, UserGroupInformation ugi) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerYarnAuthorizer.setPermission()");
        }
        try {
            this.activatePluginClassLoader();
            this.yarnAuthorizationProviderImpl.setPermission(permissions, ugi);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerYarnAuthorizer.setPermission()");
        }
    }

    public void setAdmins(AccessControlList acls, UserGroupInformation ugi) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerYarnAuthorizer.setAdmins()");
        }
        try {
            this.activatePluginClassLoader();
            this.yarnAuthorizationProviderImpl.setAdmins(acls, ugi);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerYarnAuthorizer.setAdmins()");
        }
    }

    public boolean isAdmin(UserGroupInformation ugi) {
        boolean ret = false;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerYarnAuthorizer.setAdmins()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.yarnAuthorizationProviderImpl.isAdmin(ugi);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerYarnAuthorizer.setAdmins()");
        }
        return ret;
    }

    private void activatePluginClassLoader() {
        if (this.rangerPluginClassLoader != null) {
            this.rangerPluginClassLoader.activate();
        }
    }

    private void deactivatePluginClassLoader() {
        if (this.rangerPluginClassLoader != null) {
            this.rangerPluginClassLoader.deactivate();
        }
    }
}

