/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authentication.unix.jaas;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class UsernamePasswordCallbackHandler
implements CallbackHandler {
    private String _user;
    private String _password;

    public UsernamePasswordCallbackHandler(String user, String password) {
        this._user = user;
        this._password = password;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                this.handleName((NameCallback)callback);
                continue;
            }
            if (callback instanceof PasswordCallback) {
                this.handlePassword((PasswordCallback)callback);
                continue;
            }
            throw new UnsupportedCallbackException(callback);
        }
    }

    private void handleName(NameCallback callback) {
        callback.setName(this._user);
    }

    private void handlePassword(PasswordCallback callback) {
        char[] passwordChars = this._password.toCharArray();
        callback.setPassword(passwordChars);
    }
}

