/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.schema.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.ranger.plugin.model.RangerService;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.service.RangerBaseService;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.services.schema.registry.client.AutocompletionAgent;
import org.apache.ranger.services.schema.registry.client.SchemaRegistryResourceMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerServiceSchemaRegistry
extends RangerBaseService {
    private static final Logger LOG = LoggerFactory.getLogger(RangerServiceSchemaRegistry.class);

    public void init(RangerServiceDef serviceDef, RangerService service) {
        super.init(serviceDef, service);
    }

    public HashMap<String, Object> validateConfig() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerServiceSchemaRegistry.validateConfig(" + this.serviceName + ")");
        }
        if (this.configs != null) {
            try {
                AutocompletionAgent autocompletionAgent = new AutocompletionAgent(this.serviceName, this.configs);
                ret = autocompletionAgent.connectionTest();
            }
            catch (Exception e) {
                LOG.error("<== RangerServiceSchemaRegistry.validateConfig Error:" + e);
                throw e;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerServiceSchemaRegistry.validateConfig(" + this.serviceName + "): ret=" + ret);
        }
        return ret;
    }

    public List<String> lookupResource(ResourceLookupContext context) throws Exception {
        List<String> ret = new ArrayList<String>();
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerServiceSchemaRegistry.lookupResource(" + this.serviceName + ")");
        }
        if (this.configs != null) {
            AutocompletionAgent autocompletionAgent = new AutocompletionAgent(this.serviceName, this.configs);
            ret = SchemaRegistryResourceMgr.getSchemaRegistryResources(this.serviceName, this.configs, context, autocompletionAgent);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerServiceSchemaRegistry.lookupResource(" + this.serviceName + "): ret=" + ret);
        }
        return ret;
    }
}

