/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.elasticsearch.authorizer;

import java.util.ArrayList;
import java.util.List;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.authorization.elasticsearch.authorizer.RangerElasticsearchAccessControl;
import org.apache.ranger.authorization.elasticsearch.authorizer.RangerElasticsearchAccessRequest;
import org.apache.ranger.authorization.elasticsearch.authorizer.RangerElasticsearchInnerPlugin;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.services.elasticsearch.privilege.IndexPrivilegeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerElasticsearchAuthorizer
implements RangerElasticsearchAccessControl {
    private static final Logger LOG = LoggerFactory.getLogger(RangerElasticsearchAuthorizer.class);
    private static volatile RangerElasticsearchInnerPlugin elasticsearchPlugin = null;

    public RangerElasticsearchAuthorizer() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerElasticsearchAuthorizer.RangerElasticsearchAuthorizer()");
        }
        this.init();
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerElasticsearchAuthorizer.RangerElasticsearchAuthorizer()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void init() {
        RangerElasticsearchInnerPlugin plugin;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerElasticsearchAuthorizer.init()");
        }
        if ((plugin = elasticsearchPlugin) == null) {
            Class<RangerElasticsearchAuthorizer> clazz = RangerElasticsearchAuthorizer.class;
            // MONITORENTER : org.apache.ranger.authorization.elasticsearch.authorizer.RangerElasticsearchAuthorizer.class
            plugin = elasticsearchPlugin;
            if (plugin == null) {
                plugin = new RangerElasticsearchInnerPlugin();
                plugin.init();
                elasticsearchPlugin = plugin;
            }
            // MONITOREXIT : clazz
        }
        if (!LOG.isDebugEnabled()) return;
        LOG.debug("<== RangerElasticsearchAuthorizer.init()");
    }

    public boolean checkPermission(String user, List<String> groups, String index, String action, String clientIPAddress) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerElasticsearchAuthorizer.checkPermission( user=" + user + ", groups=" + groups + ", index=" + index + ", action=" + action + ", clientIPAddress=" + clientIPAddress + ")");
        }
        boolean ret = false;
        if (elasticsearchPlugin != null) {
            String privilege;
            RangerElasticsearchAccessRequest request;
            RangerAccessResult result;
            if (null == groups) {
                groups = new ArrayList<String>(MiscUtil.getGroupsForRequestUser((String)user));
            }
            if ((result = elasticsearchPlugin.isAccessAllowed((RangerAccessRequest)(request = new RangerElasticsearchAccessRequest(user, groups, index, privilege = IndexPrivilegeUtils.getPrivilegeFromAction(action), clientIPAddress)))) != null && result.getIsAllowed()) {
                ret = true;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerElasticsearchAuthorizer.checkPermission(): result=" + ret);
        }
        return ret;
    }
}

