/*
 * Decompiled with CFR 0.152.
 */
package brave.internal;

import brave.internal.PropagationFields;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class PredefinedPropagationFields
extends PropagationFields {
    final String[] fieldNames;
    volatile String[] values;

    protected PredefinedPropagationFields(String ... fieldNames) {
        this.fieldNames = fieldNames;
    }

    protected PredefinedPropagationFields(PredefinedPropagationFields parent, String ... fieldNames) {
        this.fieldNames = fieldNames;
        this.checkSameFields(parent);
        this.values = parent.values;
    }

    @Override
    public String get(String name) {
        int index = this.indexOf(name);
        return index != -1 ? this.get(index) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(int index) {
        String[] elements;
        if (index >= this.fieldNames.length) {
            return null;
        }
        PredefinedPropagationFields predefinedPropagationFields = this;
        synchronized (predefinedPropagationFields) {
            elements = this.values;
        }
        return elements != null ? elements[index] : null;
    }

    @Override
    public final void put(String name, String value) {
        int index = this.indexOf(name);
        if (index == -1) {
            return;
        }
        this.put(index, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void put(int index, String value) {
        if (index >= this.fieldNames.length) {
            return;
        }
        PredefinedPropagationFields predefinedPropagationFields = this;
        synchronized (predefinedPropagationFields) {
            String[] elements = this.values;
            if (elements == null) {
                elements = new String[this.fieldNames.length];
                elements[index] = value;
            } else {
                if (value.equals(elements[index])) {
                    return;
                }
                elements = Arrays.copyOf(elements, elements.length);
                elements[index] = value;
            }
            this.values = elements;
        }
    }

    @Override
    protected final void putAllIfAbsent(PropagationFields parent) {
        if (!(parent instanceof PredefinedPropagationFields)) {
            return;
        }
        PredefinedPropagationFields predefinedParent = (PredefinedPropagationFields)parent;
        this.checkSameFields(predefinedParent);
        String[] parentValues = predefinedParent.values;
        if (parentValues == null) {
            return;
        }
        for (int i = 0; i < parentValues.length; ++i) {
            if (parentValues[i] == null || this.get(i) != null) continue;
            this.put(i, parentValues[i]);
        }
    }

    void checkSameFields(PredefinedPropagationFields predefinedParent) {
        if (!Arrays.equals(this.fieldNames, predefinedParent.fieldNames)) {
            throw new IllegalStateException(String.format("Mixed name configuration unsupported: found %s, expected %s", Arrays.toString(this.fieldNames), Arrays.toString(predefinedParent.fieldNames)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Map<String, String> toMap() {
        String[] elements;
        PredefinedPropagationFields predefinedPropagationFields = this;
        synchronized (predefinedPropagationFields) {
            elements = this.values;
        }
        if (elements == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> contents = new LinkedHashMap<String, String>();
        int length = this.fieldNames.length;
        for (int i = 0; i < length; ++i) {
            String maybeValue = elements[i];
            if (maybeValue == null) continue;
            contents.put(this.fieldNames[i], maybeValue);
        }
        return contents;
    }

    int indexOf(String name) {
        int length = this.fieldNames.length;
        for (int i = 0; i < length; ++i) {
            if (!this.fieldNames[i].equals(name)) continue;
            return i;
        }
        return -1;
    }

    public int hashCode() {
        return this.values == null ? 0 : Arrays.hashCode(this.values);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PredefinedPropagationFields)) {
            return false;
        }
        PredefinedPropagationFields that = (PredefinedPropagationFields)o;
        return this.values == null ? that.values == null : Arrays.equals(this.values, that.values);
    }
}

