/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.client;

import com.google.common.eventbus.Subscribe;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.servicecomb.config.client.ConnFailEvent;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemberDiscovery {
    private static final Logger LOGGER = LoggerFactory.getLogger(MemberDiscovery.class);
    private static final String SCHEMA_SEPRATOR = "://";
    private List<String> configServerAddresses = new ArrayList<String>();
    private Object lock = new Object();
    private AtomicInteger counter = new AtomicInteger(0);

    public MemberDiscovery(List<String> configCenterUri) {
        if (configCenterUri != null && !configCenterUri.isEmpty()) {
            this.configServerAddresses.addAll(configCenterUri);
        }
        Collections.shuffle(this.configServerAddresses);
        EventManager.register((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getConfigServer() {
        Object object = this.lock;
        synchronized (object) {
            if (this.configServerAddresses.isEmpty()) {
                throw new IllegalStateException("Config center address is not available.");
            }
            int index = Math.abs(this.counter.get() % this.configServerAddresses.size());
            return this.configServerAddresses.get(index);
        }
    }

    @Subscribe
    public void onConnFailEvent(ConnFailEvent e) {
        this.counter.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshMembers(JsonObject members) {
        ArrayList newServerAddresses = new ArrayList();
        members.getJsonArray("instances").forEach(m -> {
            JsonObject instance = (JsonObject)m;
            if ("UP".equals(instance.getString("status", "UP"))) {
                String endpoint = instance.getJsonArray("endpoints").getString(0);
                String scheme = instance.getBoolean("isHttps", Boolean.valueOf(false)) != false ? "https" : "http";
                newServerAddresses.add(scheme + SCHEMA_SEPRATOR + endpoint.substring(endpoint.indexOf(SCHEMA_SEPRATOR) + SCHEMA_SEPRATOR.length()));
            }
        });
        Object object = this.lock;
        synchronized (object) {
            this.configServerAddresses.clear();
            this.configServerAddresses.addAll(newServerAddresses);
            Collections.shuffle(this.configServerAddresses);
        }
        LOGGER.info("New config center members: {}", this.configServerAddresses);
    }
}

