/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler.model;

import com.google.common.base.MoreObjects;
import io.protostuff.compiler.model.AbstractElement;
import io.protostuff.compiler.model.UserType;
import java.util.Objects;

public class Range
extends AbstractElement {
    private final UserType parent;
    private final int from;
    private final int to;

    public Range(UserType parent, int from, int to) {
        this.parent = parent;
        this.from = from;
        this.to = to;
    }

    @Override
    public UserType getParent() {
        return this.parent;
    }

    public int getFrom() {
        return this.from;
    }

    public int getTo() {
        return this.to;
    }

    public boolean contains(int tag) {
        return tag >= this.from && tag <= this.to;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Range range = (Range)o;
        return this.from == range.from && this.to == range.to && Objects.equals(this.parent, range.parent);
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.from, this.to);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("from", this.from).add("to", this.to).toString();
    }
}

