/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.edge.core;

import io.vertx.core.Vertx;
import io.vertx.ext.web.RoutingContext;
import java.util.concurrent.CompletableFuture;
import org.apache.servicecomb.common.rest.RestVertxProducerInvocationCreator;
import org.apache.servicecomb.common.rest.locator.OperationLocator;
import org.apache.servicecomb.common.rest.locator.ServicePathManager;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.definition.InvocationRuntimeType;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.core.invocation.InvocationFactory;
import org.apache.servicecomb.core.provider.consumer.MicroserviceReferenceConfig;
import org.apache.servicecomb.core.provider.consumer.ReferenceConfig;
import org.apache.servicecomb.foundation.vertx.http.HttpServletRequestEx;
import org.apache.servicecomb.foundation.vertx.http.HttpServletResponseEx;

public class EdgeInvocationCreator
extends RestVertxProducerInvocationCreator {
    protected final String microserviceName;
    protected final String versionRule;
    protected final String path;
    protected MicroserviceReferenceConfig microserviceReferenceConfig;

    public EdgeInvocationCreator(RoutingContext routingContext, HttpServletRequestEx requestEx, HttpServletResponseEx responseEx, String microserviceName, String versionRule, String path) {
        super(routingContext, null, null, requestEx, responseEx);
        this.microserviceName = microserviceName;
        this.versionRule = versionRule;
        this.path = path;
    }

    public CompletableFuture<Invocation> createAsync() {
        return this.createMicroserviceReferenceConfig().thenCompose(v -> super.createAsync());
    }

    protected CompletableFuture<Void> createMicroserviceReferenceConfig() {
        return SCBEngine.getInstance().createMicroserviceReferenceConfigAsync(this.microserviceName, this.versionRule).thenAccept(mrc -> {
            this.microserviceReferenceConfig = mrc;
            this.microserviceMeta = mrc.getLatestMicroserviceMeta();
        });
    }

    protected OperationLocator locateOperation(ServicePathManager servicePathManager) {
        return servicePathManager.consumerLocateOperation(this.path, this.requestEx.getMethod());
    }

    protected Invocation createInstance() {
        ReferenceConfig referenceConfig = this.microserviceReferenceConfig.createReferenceConfig(this.restOperationMeta.getOperationMeta());
        Invocation invocation = InvocationFactory.forConsumer((ReferenceConfig)referenceConfig, (OperationMeta)this.restOperationMeta.getOperationMeta(), (InvocationRuntimeType)this.restOperationMeta.getOperationMeta().buildBaseConsumerRuntimeType(), null);
        invocation.setSync(false);
        invocation.setEdge(true);
        invocation.addLocalContext("edgeInvocationContext", (Object)Vertx.currentContext());
        return invocation;
    }
}

