/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.edge.core;

import com.google.common.eventbus.Subscribe;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.RequestOptions;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.util.HashMap;
import java.util.Map;
import org.apache.servicecomb.common.rest.route.URLMappedConfigurationItem;
import org.apache.servicecomb.common.rest.route.URLMappedConfigurationLoader;
import org.apache.servicecomb.common.rest.route.Utils;
import org.apache.servicecomb.config.BootStrapProperties;
import org.apache.servicecomb.config.ConfigurationChangedEvent;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.edge.core.AbstractEdgeDispatcher;
import org.apache.servicecomb.foundation.common.LegacyPropertyFactory;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.foundation.common.net.URIEndpointObject;
import org.apache.servicecomb.foundation.common.utils.BeanUtils;
import org.apache.servicecomb.foundation.vertx.client.http.HttpClients;
import org.apache.servicecomb.loadbalance.ExtensionsManager;
import org.apache.servicecomb.loadbalance.LoadBalancer;
import org.apache.servicecomb.loadbalance.RuleExt;
import org.apache.servicecomb.loadbalance.ServiceCombServer;
import org.apache.servicecomb.registry.discovery.DiscoveryContext;
import org.apache.servicecomb.registry.discovery.DiscoveryTree;
import org.apache.servicecomb.registry.discovery.DiscoveryTreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;

public class CommonHttpEdgeDispatcher
extends AbstractEdgeDispatcher {
    private static final Logger LOG = LoggerFactory.getLogger(CommonHttpEdgeDispatcher.class);
    private static final String KEY_ENABLED = "servicecomb.http.dispatcher.edge.http.enabled";
    private static final String KEY_ORDER = "servicecomb.http.dispatcher.edge.http.order";
    private static final String KEY_PATTERN = "servicecomb.http.dispatcher.edge.http.pattern";
    private static final String PATTERN_ANY = "/(.*)";
    private static final String KEY_MAPPING_PREFIX = "servicecomb.http.dispatcher.edge.http.mappings";
    private final Map<String, LoadBalancer> loadBalancerMap = new ConcurrentHashMapEx();
    private Map<String, URLMappedConfigurationItem> configurations = new HashMap<String, URLMappedConfigurationItem>();
    private Environment environment;

    @Autowired
    public void setEnvironment(Environment environment) {
        this.environment = environment;
        if (this.enabled()) {
            this.loadConfigurations();
        }
    }

    protected DiscoveryTree getDiscoveryTree() {
        return (DiscoveryTree)BeanUtils.getBean(DiscoveryTree.class);
    }

    protected Environment getEnvironment() {
        return (Environment)BeanUtils.getBean(Environment.class);
    }

    protected ExtensionsManager getExtensionsManager() {
        return (ExtensionsManager)BeanUtils.getBean(ExtensionsManager.class);
    }

    public int getOrder() {
        return LegacyPropertyFactory.getIntProperty((String)KEY_ORDER, (int)40000);
    }

    public boolean enabled() {
        return (Boolean)this.environment.getProperty(KEY_ENABLED, Boolean.TYPE, (Object)false);
    }

    public void init(Router router) {
        String pattern = this.environment.getProperty(KEY_PATTERN, PATTERN_ANY);
        router.routeWithRegex(pattern).failureHandler(this::onFailure).handler(this::onRequest);
    }

    private void loadConfigurations() {
        this.configurations = URLMappedConfigurationLoader.loadConfigurations((Environment)this.environment, (String)KEY_MAPPING_PREFIX);
    }

    @Subscribe
    public void onConfigurationChangedEvent(ConfigurationChangedEvent event) {
        for (String changed : event.getChanged()) {
            if (!changed.startsWith(KEY_MAPPING_PREFIX)) continue;
            this.loadConfigurations();
            break;
        }
    }

    protected void onRequest(RoutingContext context) {
        final URLMappedConfigurationItem configurationItem = this.findConfigurationItem(context.request().uri());
        if (configurationItem == null) {
            context.next();
            return;
        }
        String uri = Utils.findActualPath((String)context.request().uri(), (int)configurationItem.getPrefixSegmentCount());
        Invocation invocation = new Invocation(){

            public String getConfigTransportName() {
                return "rest";
            }

            public String getMicroserviceName() {
                return configurationItem.getMicroserviceName();
            }
        };
        LoadBalancer loadBalancer = this.getOrCreateLoadBalancer(invocation, configurationItem.getMicroserviceName());
        ServiceCombServer server = loadBalancer.chooseServer(invocation);
        if (server == null) {
            LOG.warn("no available server for service {}", (Object)configurationItem.getMicroserviceName());
            this.serverNotReadyResponse(context);
            return;
        }
        URIEndpointObject endpointObject = new URIEndpointObject(server.getEndpoint().getEndpoint());
        RequestOptions requestOptions = new RequestOptions();
        requestOptions.setHost(endpointObject.getHostOrIp()).setPort(Integer.valueOf(endpointObject.getPort())).setSsl(Boolean.valueOf(endpointObject.isSslEnabled())).setMethod(context.request().method()).setURI(uri);
        HttpClient httpClient = endpointObject.isHttp2Enabled() ? HttpClients.getClient((String)"http2-transport-client", (boolean)false).getHttpClient() : HttpClients.getClient((String)"http-transport-client", (boolean)false).getHttpClient();
        context.request().pause();
        httpClient.request(requestOptions).compose(httpClientRequest -> {
            context.request().headers().forEach(header -> httpClientRequest.headers().set((String)header.getKey(), (String)header.getValue()));
            context.request().resume();
            context.request().handler(arg_0 -> ((HttpClientRequest)httpClientRequest).write(arg_0));
            context.request().endHandler(v -> httpClientRequest.end());
            return httpClientRequest.response().compose(httpClientResponse -> {
                context.response().setStatusCode(httpClientResponse.statusCode());
                httpClientResponse.headers().forEach(header -> context.response().headers().set((String)header.getKey(), (String)header.getValue()));
                httpClientResponse.handler(this.responseHandler(context));
                httpClientResponse.endHandler(v -> context.response().end());
                return Future.succeededFuture();
            });
        }).onFailure(failure -> {
            LOG.warn("send request to target {}:{} failed, cause {}", new Object[]{endpointObject.getHostOrIp(), endpointObject.getPort(), failure.getMessage()});
            this.serverNotReadyResponse(context);
        });
    }

    private void serverNotReadyResponse(RoutingContext context) {
        context.response().setStatusCode(503);
        context.response().setStatusMessage("service not ready");
        context.response().end();
    }

    protected Handler<Buffer> responseHandler(RoutingContext routingContext) {
        return data -> routingContext.response().write(data);
    }

    protected LoadBalancer getOrCreateLoadBalancer(Invocation invocation, String microserviceName) {
        DiscoveryContext context = new DiscoveryContext();
        context.setInputParameters((Object)invocation);
        DiscoveryTreeNode serversVersionedCache = this.getDiscoveryTree().discovery(context, BootStrapProperties.readApplication((Environment)this.environment), microserviceName);
        invocation.addLocalContext("x-context-server-list", serversVersionedCache.data());
        return this.loadBalancerMap.computeIfAbsent(microserviceName, name -> this.createLoadBalancer(microserviceName));
    }

    private LoadBalancer createLoadBalancer(String microserviceName) {
        RuleExt rule = this.getExtensionsManager().createLoadBalancerRule(microserviceName);
        return new LoadBalancer(rule, microserviceName);
    }

    private URLMappedConfigurationItem findConfigurationItem(String path) {
        for (URLMappedConfigurationItem item : this.configurations.values()) {
            if (!item.getPattern().matcher(path).matches()) continue;
            return item;
        }
        return null;
    }
}

