/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.codec.header;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.Response;
import java.util.Collection;
import java.util.List;
import java.util.StringJoiner;
import org.apache.servicecomb.common.rest.codec.RestClientRequest;
import org.apache.servicecomb.common.rest.codec.RestObjectMapperFactory;
import org.apache.servicecomb.common.rest.codec.header.HeaderCodec;
import org.apache.servicecomb.common.rest.codec.param.HeaderProcessorCreator;
import org.apache.servicecomb.swagger.invocation.exception.CommonExceptionData;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;

public abstract class HeaderCodecWithDelimiter
implements HeaderCodec {
    private final String name;
    private final String joinDelimiter;
    private final String splitDelimiter;

    public HeaderCodecWithDelimiter(String name, String joinDelimiter, String splitDelimiter) {
        this.name = name;
        this.joinDelimiter = joinDelimiter;
        this.splitDelimiter = splitDelimiter;
    }

    @Override
    public String getCodecName() {
        return this.name;
    }

    @Override
    public void encode(RestClientRequest clientRequest, String name, Object value) throws Exception {
        if (null == value) {
            return;
        }
        if (!(value instanceof Collection)) {
            throw new InvocationException((Response.StatusType)Response.Status.BAD_REQUEST, (Object)new CommonExceptionData("Array type of header should be Collection"));
        }
        clientRequest.putHeader(name, this.join((Collection)value));
    }

    protected String join(Collection<?> values) throws Exception {
        StringJoiner joiner = new StringJoiner(this.joinDelimiter);
        for (Object value : values) {
            String strValue = RestObjectMapperFactory.getConsumerWriterMapper().convertToString(value);
            joiner.add(strValue);
        }
        return joiner.toString();
    }

    @Override
    public Object decode(HeaderProcessorCreator.HeaderProcessor processor, HttpServletRequest request) {
        String headerValues = request.getHeader(processor.getParameterPath());
        if (headerValues == null) {
            headerValues = (String)processor.checkRequiredAndDefaultValue();
        }
        return processor.convertValue(List.of(headerValues.split(this.splitDelimiter)), processor.getTargetType());
    }
}

