/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.center.client;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ConfigCenterConfigurationChangedEvent {
    private final Map<String, Object> added;
    private final Map<String, Object> deleted;
    private final Map<String, Object> updated;
    private Set<String> changed;

    private ConfigCenterConfigurationChangedEvent(Map<String, Object> added, Map<String, Object> updated, Map<String, Object> deleted) {
        this.added = added;
        this.deleted = deleted;
        this.updated = updated;
        this.changed = new HashSet<String>();
        this.changed.addAll(added.keySet());
        this.changed.addAll(updated.keySet());
        this.changed.addAll(deleted.keySet());
    }

    public static ConfigCenterConfigurationChangedEvent createIncremental(Map<String, Object> latest, Map<String, Object> last) {
        HashMap<String, Object> itemsCreated = new HashMap<String, Object>();
        HashMap<String, Object> itemsDeleted = new HashMap<String, Object>();
        HashMap<String, Object> itemsModified = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : latest.entrySet()) {
            String itemKey = entry.getKey();
            if (!last.containsKey(itemKey)) {
                itemsCreated.put(itemKey, entry.getValue());
                continue;
            }
            if (Objects.equals(last.get(itemKey), latest.get(itemKey))) continue;
            itemsModified.put(itemKey, entry.getValue());
        }
        for (String itemKey : last.keySet()) {
            if (latest.containsKey(itemKey)) continue;
            itemsDeleted.put(itemKey, null);
        }
        ConfigCenterConfigurationChangedEvent event = ConfigCenterConfigurationChangedEvent.createIncremental(itemsCreated, itemsModified, itemsDeleted);
        return event;
    }

    public static ConfigCenterConfigurationChangedEvent createIncremental(Map<String, Object> added, Map<String, Object> updated, Map<String, Object> deleted) {
        return new ConfigCenterConfigurationChangedEvent(added, updated, deleted);
    }

    public static ConfigCenterConfigurationChangedEvent createIncremental(Map<String, Object> updated) {
        return new ConfigCenterConfigurationChangedEvent(new HashMap<String, Object>(), updated, new HashMap<String, Object>());
    }

    public final Map<String, Object> getAdded() {
        return this.added;
    }

    public final Map<String, Object> getUpdated() {
        return this.updated;
    }

    public final Map<String, Object> getDeleted() {
        return this.deleted;
    }

    public final Set<String> getChanged() {
        return this.changed;
    }
}

