/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.meter;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.skywalking.apm.agent.core.boot.BootService;
import org.apache.skywalking.apm.agent.core.boot.DefaultImplementor;
import org.apache.skywalking.apm.agent.core.boot.DefaultNamedThreadFactory;
import org.apache.skywalking.apm.agent.core.boot.ServiceManager;
import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.meter.BaseMeter;
import org.apache.skywalking.apm.agent.core.meter.MeterId;
import org.apache.skywalking.apm.agent.core.meter.MeterSender;
import org.apache.skywalking.apm.util.RunnableWithExceptionProtection;

@DefaultImplementor
public class MeterService
implements BootService,
Runnable {
    private static final ILog LOGGER = LogManager.getLogger(MeterService.class);
    private final ConcurrentHashMap<MeterId, BaseMeter> meterMap = new ConcurrentHashMap();
    private volatile ScheduledFuture<?> reportMeterFuture;
    private MeterSender sender;

    public <T extends BaseMeter> T register(T meter) {
        if (meter == null) {
            return null;
        }
        if (this.meterMap.size() >= Config.Meter.MAX_METER_SIZE) {
            LOGGER.warn("Already out of the meter system max size [{}], will not report. meter name:{}, meter size:{}", Config.Meter.MAX_METER_SIZE, meter.getName(), this.meterMap.size());
            return meter;
        }
        BaseMeter data = this.meterMap.putIfAbsent(meter.getId(), meter);
        return (T)(data == null ? meter : data);
    }

    @Override
    public void prepare() {
        this.sender = ServiceManager.INSTANCE.findService(MeterSender.class);
    }

    @Override
    public void boot() {
        if (Config.Meter.ACTIVE) {
            this.reportMeterFuture = Executors.newSingleThreadScheduledExecutor(new DefaultNamedThreadFactory("MeterReportService")).scheduleWithFixedDelay(new RunnableWithExceptionProtection(this, t -> LOGGER.error("Report meters failure.", t)), 0L, Config.Meter.REPORT_INTERVAL.intValue(), TimeUnit.SECONDS);
        }
    }

    @Override
    public void onComplete() {
    }

    @Override
    public void shutdown() {
        if (this.reportMeterFuture != null) {
            this.reportMeterFuture.cancel(true);
        }
        this.meterMap.clear();
    }

    @Override
    public void run() {
        if (this.meterMap.isEmpty()) {
            return;
        }
        this.sender.send(this.meterMap, this);
    }
}

