/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.plugin.match;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.skywalking.apm.agent.core.plugin.match.IndirectMatch;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.description.annotation.AnnotationDescription;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.description.annotation.AnnotationList;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.description.type.TypeDescription;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.matcher.ElementMatcher;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.matcher.ElementMatchers;

public class ClassAnnotationMatch
implements IndirectMatch {
    private String[] annotations;

    private ClassAnnotationMatch(String[] annotations) {
        if (annotations == null || annotations.length == 0) {
            throw new IllegalArgumentException("annotations is null");
        }
        this.annotations = annotations;
    }

    @Override
    public ElementMatcher.Junction buildJunction() {
        ElementMatcher.Junction junction = null;
        for (String annotation : this.annotations) {
            junction = junction == null ? this.buildEachAnnotation(annotation) : junction.and(this.buildEachAnnotation(annotation));
        }
        junction = junction.and(ElementMatchers.not(ElementMatchers.isInterface()));
        return junction;
    }

    @Override
    public boolean isMatch(TypeDescription typeDescription) {
        ArrayList<String> annotationList = new ArrayList<String>(Arrays.asList(this.annotations));
        AnnotationList declaredAnnotations = typeDescription.getDeclaredAnnotations();
        for (AnnotationDescription annotation : declaredAnnotations) {
            annotationList.remove(annotation.getAnnotationType().getActualName());
        }
        return annotationList.isEmpty();
    }

    private ElementMatcher.Junction buildEachAnnotation(String annotationName) {
        return ElementMatchers.isAnnotatedWith(ElementMatchers.named(annotationName));
    }

    public static ClassAnnotationMatch byClassAnnotationMatch(String ... annotations) {
        return new ClassAnnotationMatch(annotations);
    }
}

