/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.scala.collection;

import coursierapi.shaded.scala.Function0;
import coursierapi.shaded.scala.Function1;
import coursierapi.shaded.scala.MatchError;
import coursierapi.shaded.scala.None$;
import coursierapi.shaded.scala.Option;
import coursierapi.shaded.scala.PartialFunction;
import coursierapi.shaded.scala.Some;
import coursierapi.shaded.scala.Tuple2;
import coursierapi.shaded.scala.collection.AbstractView;
import coursierapi.shaded.scala.collection.Iterable;
import coursierapi.shaded.scala.collection.IterableFactory;
import coursierapi.shaded.scala.collection.IterableOnce;
import coursierapi.shaded.scala.collection.IterableOnceOps;
import coursierapi.shaded.scala.collection.Iterator;
import coursierapi.shaded.scala.collection.View;
import coursierapi.shaded.scala.collection.immutable.HashMap;
import coursierapi.shaded.scala.collection.immutable.HashMap$;
import coursierapi.shaded.scala.collection.immutable.Map;
import coursierapi.shaded.scala.collection.immutable.Nil$;
import coursierapi.shaded.scala.collection.mutable.Builder;
import coursierapi.shaded.scala.collection.mutable.Map$;
import coursierapi.shaded.scala.runtime.BoxesRunTime;
import java.io.Serializable;

public interface IterableOps<A, CC, C>
extends IterableOnce<A>,
IterableOnceOps<A, CC, C> {
    public C coll();

    public C fromSpecific(IterableOnce<A> var1);

    public IterableFactory<CC> iterableFactory();

    public Builder<A, C> newSpecificBuilder();

    default public C empty() {
        return this.fromSpecific(Nil$.MODULE$);
    }

    public static /* synthetic */ Object head$(IterableOps $this) {
        return $this.head();
    }

    default public A head() {
        return this.iterator().next();
    }

    public static /* synthetic */ Option headOption$(IterableOps $this) {
        return $this.headOption();
    }

    default public Option<A> headOption() {
        Iterator it = this.iterator();
        if (it.hasNext()) {
            return new Some(it.next());
        }
        return None$.MODULE$;
    }

    public static /* synthetic */ Object last$(IterableOps $this) {
        return $this.last();
    }

    default public A last() {
        Iterator it = this.iterator();
        Object lst = it.next();
        while (it.hasNext()) {
            lst = it.next();
        }
        return lst;
    }

    public static /* synthetic */ Option lastOption$(IterableOps $this) {
        return $this.lastOption();
    }

    default public Option<A> lastOption() {
        if (this.isEmpty()) {
            return None$.MODULE$;
        }
        return new Some<A>(this.last());
    }

    public static /* synthetic */ View view$(IterableOps $this) {
        return $this.view();
    }

    default public View<A> view() {
        Function0<Iterator> & Serializable fromIteratorProvider_it = (Function0<Iterator> & Serializable)() -> this.iterator();
        return new AbstractView<A>(fromIteratorProvider_it){
            private final Function0 it$1;

            public Iterator<A> iterator() {
                return (Iterator)this.it$1.apply();
            }
            {
                this.it$1 = it$1;
            }
        };
    }

    public static /* synthetic */ int sizeCompare$(IterableOps $this, int otherSize) {
        return $this.sizeCompare(otherSize);
    }

    default public int sizeCompare(int otherSize) {
        if (otherSize < 0) {
            return 1;
        }
        int known = this.knownSize();
        if (known >= 0) {
            return Integer.compare(known, otherSize);
        }
        int i = 0;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            if (i == otherSize) {
                return 1;
            }
            it.next();
            ++i;
        }
        return i - otherSize;
    }

    public static /* synthetic */ Object filter$(IterableOps $this, Function1 pred) {
        return $this.filter(pred);
    }

    default public C filter(Function1<A, Object> pred) {
        return this.fromSpecific(new View.Filter<A>(this, pred, false));
    }

    public static /* synthetic */ Object filterNot$(IterableOps $this, Function1 pred) {
        return $this.filterNot(pred);
    }

    default public C filterNot(Function1<A, Object> pred) {
        return this.fromSpecific(new View.Filter<A>(this, pred, true));
    }

    public static /* synthetic */ coursierapi.shaded.scala.collection.WithFilter withFilter$(IterableOps $this, Function1 p) {
        return $this.withFilter(p);
    }

    default public coursierapi.shaded.scala.collection.WithFilter<A, CC> withFilter(Function1<A, Object> p) {
        return new WithFilter(this, p);
    }

    public static /* synthetic */ Tuple2 partition$(IterableOps $this, Function1 p) {
        return $this.partition(p);
    }

    default public Tuple2<C, C> partition(Function1<A, Object> p) {
        View.Filter<A> first = new View.Filter<A>(this, p, false);
        View.Filter<A> second = new View.Filter<A>(this, p, true);
        return new Tuple2<C, C>(this.fromSpecific(first), this.fromSpecific(second));
    }

    public static /* synthetic */ Tuple2 splitAt$(IterableOps $this, int n) {
        return $this.splitAt(n);
    }

    default public Tuple2<C, C> splitAt(int n) {
        return new Tuple2<C, C>(this.take(n), this.drop(n));
    }

    public static /* synthetic */ Object take$(IterableOps $this, int n) {
        return $this.take(n);
    }

    default public C take(int n) {
        return this.fromSpecific(new View.Take(this, n));
    }

    public static /* synthetic */ Object takeWhile$(IterableOps $this, Function1 p) {
        return $this.takeWhile(p);
    }

    default public C takeWhile(Function1<A, Object> p) {
        return this.fromSpecific(new View.TakeWhile<A>(this, p));
    }

    public static /* synthetic */ Object drop$(IterableOps $this, int n) {
        return $this.drop(n);
    }

    default public C drop(int n) {
        return this.fromSpecific(new View.Drop(this, n));
    }

    public static /* synthetic */ Object dropRight$(IterableOps $this, int n) {
        return $this.dropRight(n);
    }

    default public C dropRight(int n) {
        return this.fromSpecific(new View.DropRight(this, n));
    }

    public static /* synthetic */ Object dropWhile$(IterableOps $this, Function1 p) {
        return $this.dropWhile(p);
    }

    default public C dropWhile(Function1<A, Object> p) {
        return this.fromSpecific(new View.DropWhile<A>(this, p));
    }

    public static /* synthetic */ Object tail$(IterableOps $this) {
        return $this.tail();
    }

    default public C tail() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException();
        }
        return this.drop(1);
    }

    public static /* synthetic */ Object init$(IterableOps $this) {
        return $this.init();
    }

    default public C init() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException();
        }
        return this.dropRight(1);
    }

    public static /* synthetic */ Object slice$(IterableOps $this, int from, int until) {
        return $this.slice(from, until);
    }

    default public C slice(int from, int until) {
        return this.fromSpecific(new View.Drop(new View.Take(this, until), from));
    }

    public static /* synthetic */ Map groupBy$(IterableOps $this, Function1 f) {
        return $this.groupBy(f);
    }

    /*
     * WARNING - void declaration
     */
    default public <K$> Map<K$, C> groupBy(Function1<A, K$> f) {
        coursierapi.shaded.scala.collection.mutable.Map m = (coursierapi.shaded.scala.collection.mutable.Map)Map$.MODULE$.empty();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Object elem = it.next();
            K$ key = f.apply(elem);
            Builder bldr = (Builder)m.getOrElseUpdate(key, (Function0<Builder> & Serializable)() -> this.newSpecificBuilder());
            if (bldr == null) {
                throw null;
            }
            bldr.addOne(elem);
        }
        Object result = HashMap$.MODULE$.empty();
        Iterator mapIt = m.iterator();
        while (mapIt.hasNext()) {
            void var11_11;
            void var10_10;
            Tuple2 tuple2 = (Tuple2)mapIt.next();
            if (tuple2 == null) {
                throw new MatchError((Object)null);
            }
            Object k = tuple2._1();
            Builder v = (Builder)tuple2._2();
            result = ((HashMap)result).updated((Object)var10_10, var11_11.result());
        }
        return result;
    }

    public static /* synthetic */ Object map$(IterableOps $this, Function1 f) {
        return $this.map(f);
    }

    default public <B> CC map(Function1<A, B> f) {
        return this.iterableFactory().from(new View.Map<A, B>(this, f));
    }

    public static /* synthetic */ Object flatMap$(IterableOps $this, Function1 f) {
        return $this.flatMap(f);
    }

    default public <B> CC flatMap(Function1<A, IterableOnce<B>> f) {
        return this.iterableFactory().from(new View.FlatMap<A, B>(this, f));
    }

    public static /* synthetic */ Object flatten$(IterableOps $this, Function1 asIterable) {
        return $this.flatten(asIterable);
    }

    default public <B> CC flatten(Function1<A, IterableOnce<B>> asIterable) {
        return this.flatMap(asIterable);
    }

    public static /* synthetic */ Object collect$(IterableOps $this, PartialFunction pf) {
        return $this.collect(pf);
    }

    default public <B> CC collect(PartialFunction<A, B> pf) {
        return this.iterableFactory().from(new View.Collect<A, B>(this, pf));
    }

    public static /* synthetic */ Object concat$(IterableOps $this, IterableOnce suffix) {
        return $this.concat(suffix);
    }

    /*
     * WARNING - void declaration
     */
    default public <B> CC concat(IterableOnce<B> suffix) {
        IterableOnce<Object> iterableOnce;
        IterableFactory<CC> iterableFactory = this.iterableFactory();
        if (suffix instanceof Iterable) {
            Iterable iterable = (Iterable)suffix;
            iterableOnce = new View.Concat(this, iterable);
        } else {
            void $plus$plus_xs;
            Iterator iterator = this.iterator();
            Function0<Iterator> & Serializable intersect = (Function0<Iterator> & Serializable)() -> suffix.iterator();
            if (iterator == null) {
                throw null;
            }
            iterableOnce = iterator.concat($plus$plus_xs);
            intersect = null;
        }
        return iterableFactory.from(iterableOnce);
    }

    public static /* synthetic */ Object $plus$plus$(IterableOps $this, IterableOnce suffix) {
        return $this.$plus$plus(suffix);
    }

    default public <B> CC $plus$plus(IterableOnce<B> suffix) {
        return this.concat(suffix);
    }

    public static /* synthetic */ Object zip$(IterableOps $this, IterableOnce that) {
        return $this.zip(that);
    }

    default public <B> CC zip(IterableOnce<B> that) {
        IterableOnce<Tuple2<Object, Object>> iterableOnce;
        IterableFactory<CC> iterableFactory = this.iterableFactory();
        if (that instanceof Iterable) {
            Iterable iterable = (Iterable)that;
            iterableOnce = new View.Zip(this, iterable);
        } else {
            iterableOnce = this.iterator().zip(that);
        }
        return iterableFactory.from(iterableOnce);
    }

    public static /* synthetic */ Object zipWithIndex$(IterableOps $this) {
        return $this.zipWithIndex();
    }

    default public CC zipWithIndex() {
        return this.iterableFactory().from(new View.ZipWithIndex(this));
    }

    public static /* synthetic */ Tuple2 unzip$(IterableOps $this, Function1 asPair) {
        return $this.unzip(asPair);
    }

    default public <A1, A2> Tuple2<CC, CC> unzip(Function1<A, Tuple2<A1, A2>> asPair) {
        View.Map first = new View.Map(this, (Function1<Object, Object> & Serializable)x$3 -> ((Tuple2)asPair.apply(x$3))._1());
        View.Map second = new View.Map(this, (Function1<Object, Object> & Serializable)x$4 -> ((Tuple2)asPair.apply(x$4))._2());
        return new Tuple2<CC, CC>(this.iterableFactory().from(first), this.iterableFactory().from(second));
    }

    public static class WithFilter<A, CC>
    extends coursierapi.shaded.scala.collection.WithFilter<A, CC> {
        private final IterableOps<A, CC, ?> self;
        private final Function1<A, Object> p;

        public Iterable<A> filtered() {
            return new View.Filter<A>(this.self, this.p, false);
        }

        @Override
        public <B> CC map(Function1<A, B> f) {
            return this.self.iterableFactory().from(new View.Map<A, B>(this.filtered(), f));
        }

        @Override
        public <B> CC flatMap(Function1<A, IterableOnce<B>> f) {
            return this.self.iterableFactory().from(new View.FlatMap<A, B>(this.filtered(), f));
        }

        @Override
        public <U> void foreach(Function1<A, U> f) {
            this.filtered().foreach(f);
        }

        @Override
        public WithFilter<A, CC> withFilter(Function1<A, Object> q) {
            return new WithFilter<A, CC>(this.self, (Function1<Object, Object> & Serializable)a -> BoxesRunTime.boxToBoolean(WithFilter.$anonfun$withFilter$1(this, q, a)));
        }

        public static final /* synthetic */ boolean $anonfun$withFilter$1(WithFilter $this, Function1 q$1, Object a) {
            return BoxesRunTime.unboxToBoolean($this.p.apply(a)) && BoxesRunTime.unboxToBoolean(q$1.apply(a));
        }

        public WithFilter(IterableOps<A, CC, ?> self, Function1<A, Object> p) {
            this.self = self;
            this.p = p;
        }
    }
}

