/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import java.util.Arrays;
import java.util.List;
import org.apache.spark.ml.feature.Imputer;
import org.apache.spark.ml.feature.ImputerModel;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class JavaImputerExample {
    public static void main(String[] args) {
        SparkSession spark = SparkSession.builder().appName("JavaImputerExample").getOrCreate();
        List<Row> data = Arrays.asList(RowFactory.create((Object[])new Object[]{1.0, Double.NaN}), RowFactory.create((Object[])new Object[]{2.0, Double.NaN}), RowFactory.create((Object[])new Object[]{Double.NaN, 3.0}), RowFactory.create((Object[])new Object[]{4.0, 4.0}), RowFactory.create((Object[])new Object[]{5.0, 5.0}));
        StructType schema = new StructType(new StructField[]{DataTypes.createStructField((String)"a", (DataType)DataTypes.DoubleType, (boolean)false), DataTypes.createStructField((String)"b", (DataType)DataTypes.DoubleType, (boolean)false)});
        Dataset df = spark.createDataFrame(data, schema);
        Imputer imputer = new Imputer().setInputCols(new String[]{"a", "b"}).setOutputCols(new String[]{"out_a", "out_b"});
        ImputerModel model = imputer.fit(df);
        model.transform(df).show();
        spark.stop();
    }
}

