/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.common.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.locks.LockSupport;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.commons.lang3.StringUtils;
import org.apache.streampark.common.util.Logger;
import org.apache.streampark.common.util.Logger$class;
import org.apache.streampark.common.util.Utils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class Utils$
implements Logger {
    public static final Utils$ MODULE$;
    private String OS;
    private transient org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger;
    private final String org$apache$streampark$common$util$Logger$$prefix;
    private volatile boolean bitmap$0;

    static {
        new Utils$();
    }

    private String OS$lzycompute() {
        Utils$ utils$ = this;
        synchronized (utils$) {
            if (!this.bitmap$0) {
                this.OS = System.getProperty("os.name").toLowerCase();
                this.bitmap$0 = true;
            }
            return this.OS;
        }
    }

    @Override
    public org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger() {
        return this.org$apache$streampark$common$util$Logger$$_logger;
    }

    @Override
    public void org$apache$streampark$common$util$Logger$$_logger_$eq(org.apache.streampark.shaded.org.slf4j.Logger x$1) {
        this.org$apache$streampark$common$util$Logger$$_logger = x$1;
    }

    @Override
    public String org$apache$streampark$common$util$Logger$$prefix() {
        return this.org$apache$streampark$common$util$Logger$$prefix;
    }

    @Override
    public void org$apache$streampark$common$util$Logger$_setter_$org$apache$streampark$common$util$Logger$$prefix_$eq(String x$1) {
        this.org$apache$streampark$common$util$Logger$$prefix = x$1;
    }

    @Override
    public String logName() {
        return Logger$class.logName(this);
    }

    @Override
    public org.apache.streampark.shaded.org.slf4j.Logger logger() {
        return Logger$class.logger(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logger$class.logInfo(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logger$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logger$class.logDebug(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logger$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logger$class.logTrace(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logger$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarn(Function0<String> msg) {
        Logger$class.logWarn(this, msg);
    }

    @Override
    public void logWarn(Function0<String> msg, Throwable throwable) {
        Logger$class.logWarn(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logger$class.logError(this, msg);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logger$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logger$class.isTraceEnabled(this);
    }

    private String OS() {
        return this.bitmap$0 ? this.OS : this.OS$lzycompute();
    }

    public void notNull(Object obj, String message) {
        if (obj == null) {
            throw new NullPointerException(message);
        }
    }

    public void notNull(Object obj) {
        this.notNull(obj, "this argument must not be null");
    }

    public boolean notEmpty(Object elem) {
        Object object = elem;
        boolean bl = object == null ? false : (ScalaRunTime$.MODULE$.isArray(object, 1) ? Predef$.MODULE$.genericArrayOps(elem).nonEmpty() : (object instanceof CharSequence ? new StringOps(Predef$.MODULE$.augmentString(elem.toString().trim())).nonEmpty() : (object instanceof Traversable ? ((Traversable)object).nonEmpty() : (object instanceof Iterable ? ((Iterable)object).nonEmpty() : (object instanceof Collection ? !((Collection)object).isEmpty() : (object instanceof Map ? !((Map)object).isEmpty() : true))))));
        return bl;
    }

    public boolean isEmpty(Object elem) {
        return !this.notEmpty(elem);
    }

    public void required(boolean expression) {
        if (expression) {
            return;
        }
        throw new IllegalArgumentException();
    }

    public void required(boolean expression, Object errorMessage) {
        if (expression) {
            return;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"requirement failed: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{errorMessage.toString()})));
    }

    public String uuid() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public void checkJarFile(URL jar) throws IOException {
        Try try_ = Try$.MODULE$.apply((Function0)new Serializable(jar){
            public static final long serialVersionUID = 0L;
            private final URL jar$1;

            public final File apply() {
                return new File(this.jar$1.toURI());
            }
            {
                this.jar$1 = jar$1;
            }
        });
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            File x = (File)success.value();
            File file = x;
            File jarFile = file;
            if (jarFile.exists()) {
                if (jarFile.canRead()) {
                    Try try_2 = Try$.MODULE$.apply((Function0)new Serializable(jarFile){
                        public static final long serialVersionUID = 0L;
                        private final File jarFile$1;

                        public final JarFile apply() {
                            return new JarFile(this.jarFile$1);
                        }
                        {
                            this.jarFile$1 = jarFile$1;
                        }
                    });
                    if (try_2 instanceof Failure) {
                        Failure failure = (Failure)try_2;
                        Throwable e = failure.exception();
                        throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while opening jar file '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jarFile.getAbsolutePath()})), e);
                    }
                    if (try_2 instanceof Success) {
                        Success success2 = (Success)try_2;
                        JarFile x2 = (JarFile)success2.value();
                        x2.close();
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError((Object)try_2);
                }
                throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"JAR file can't be read '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jarFile.getAbsolutePath()})));
            }
            throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"JAR file does not exist '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jarFile.getAbsolutePath()})));
        }
        if (try_ instanceof Failure) {
            throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"JAR file path is invalid ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jar})));
        }
        throw new MatchError((Object)try_);
    }

    public Manifest getJarManifest(File jarFile) {
        this.checkJarFile(jarFile.toURL());
        return new JarInputStream(new BufferedInputStream(new FileInputStream(jarFile))).getManifest();
    }

    public String getJarManClass(File jarFile) {
        Manifest manifest = this.getJarManifest(jarFile);
        Attributes mainAttr = manifest.getMainAttributes();
        return (String)Option$.MODULE$.apply((Object)mainAttr.getValue("Main-Class")).getOrElse((Function0)new Serializable(mainAttr){
            public static final long serialVersionUID = 0L;
            private final Attributes mainAttr$1;

            public final String apply() {
                return (String)Option$.MODULE$.apply((Object)this.mainAttr$1.getValue("program-class")).orNull(Predef$.MODULE$.$conforms());
            }
            {
                this.mainAttr$1 = mainAttr$1;
            }
        });
    }

    public void copyProperties(Properties original, Properties target) {
        JavaConversions$.MODULE$.propertiesAsScalaMap(original).foreach((Function1)new Serializable(target){
            public static final long serialVersionUID = 0L;
            private final Properties target$1;

            public final Object apply(Tuple2<String, String> x) {
                return this.target$1.put(x._1(), x._2());
            }
            {
                this.target$1 = target$1;
            }
        });
    }

    public String getOsName() {
        return this.OS();
    }

    public boolean isLinux() {
        return this.OS().indexOf("linux") >= 0;
    }

    public boolean isWindows() {
        return this.OS().indexOf("windows") >= 0;
    }

    public boolean isAnyBank(Seq<String> items) {
        return items == null || items.exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(CharSequence x$1) {
                return StringUtils.isBlank((CharSequence)x$1);
            }
        });
    }

    public <R, T extends AutoCloseable> R using(T handle, Function1<T, R> func, Function1<Throwable, R> excFunc) {
        Object object;
        try {
            try {
                object = func.apply(handle);
            }
            catch (Throwable throwable) {
                if (excFunc == null) {
                    throw throwable;
                }
                object = excFunc.apply((Object)throwable);
            }
        }
        finally {
            if (handle != null) {
                handle.close();
            }
        }
        return (R)object;
    }

    public <R, T extends AutoCloseable> Null$ using$default$3(T handle, Function1<T, R> func) {
        return null;
    }

    public void close(Seq<AutoCloseable> closeable, Function1<Throwable, BoxedUnit> func) {
        closeable.foreach((Function1)new Serializable(func){
            public static final long serialVersionUID = 0L;
            private final Function1 func$1;

            public final void apply(AutoCloseable c) {
                Throwable throwable2;
                block3: {
                    try {
                        if (c != null) {
                            c.close();
                        }
                    }
                    catch (Throwable throwable2) {
                        Throwable throwable3 = throwable2;
                        if (throwable3 == null) break block3;
                        Throwable throwable4 = throwable3;
                        if (this.func$1 == null) break block3;
                        BoxedUnit boxedUnit = (BoxedUnit)this.func$1.apply((Object)throwable4);
                    }
                    return;
                }
                throw throwable2;
            }
            {
                this.func$1 = func$1;
            }
        });
    }

    public Function1<Throwable, BoxedUnit> close$default$2(Seq<AutoCloseable> closeable) {
        return null;
    }

    public <R> Try<R> retry(int retryCount, Duration interval, Function0<R> f) {
        Try try_;
        block6: {
            Success success;
            block5: {
                Failure failure;
                boolean bl;
                while (true) {
                    Predef$.MODULE$.require(retryCount >= 0);
                    bl = false;
                    failure = null;
                    try_ = Try$.MODULE$.apply(f);
                    if (try_ instanceof Success) {
                        Success success2 = (Success)try_;
                        Object result = success2.value();
                        success = new Success(result);
                        break block5;
                    }
                    if (!(try_ instanceof Failure)) break;
                    bl = true;
                    failure = (Failure)try_;
                    Throwable e = failure.exception();
                    if (retryCount <= 0) break;
                    this.logWarn((Function0<String>)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"retry failed, execution caused by: "})).s((Seq)Nil$.MODULE$);
                        }
                    }, e);
                    this.logWarn((Function0<String>)new Serializable(retryCount, interval){
                        public static final long serialVersionUID = 0L;
                        private final int retryCount$1;
                        private final Duration interval$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " times retry remaining, the next attempt will be in ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.retryCount$1), BoxesRunTime.boxToLong((long)this.interval$1.toMillis())}));
                        }
                        {
                            this.retryCount$1 = retryCount$1;
                            this.interval$1 = interval$1;
                        }
                    });
                    LockSupport.parkNanos(interval.toNanos());
                    --retryCount;
                }
                if (!bl) break block6;
                Throwable e = failure.exception();
                success = new Failure(e);
            }
            return success;
        }
        throw new MatchError((Object)try_);
    }

    public <R> Duration retry$default$2() {
        return Duration.ofSeconds(5L);
    }

    public double calPercent(long num1, long num2) {
        return num1 == 0L || num2 == 0L ? 0.0 : new StringOps(Predef$.MODULE$.augmentString(Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat((Object)BoxesRunTime.boxToDouble((double)((double)num1 / (double)num2 * (double)100))), "%.1f"))).toDouble();
    }

    public int hashCode(Seq<Object> elements) {
        if (elements == null) {
            return 0;
        }
        IntRef result = IntRef.create((int)1);
        elements.foreach((Function1)new Serializable(result){
            public static final long serialVersionUID = 0L;
            private final IntRef result$1;

            public final void apply(Object elem) {
                int hash = elem == null ? 0 : elem.hashCode();
                this.result$1.elem = 31 * this.result$1.elem + hash;
            }
            {
                this.result$1 = result$1;
            }
        });
        return result.elem;
    }

    public String stringifyException(Throwable e) {
        String string;
        if (e == null) {
            string = "(null)";
        } else {
            try {
                StringWriter stm = new StringWriter();
                PrintWriter wrt = new PrintWriter(stm);
                e.printStackTrace(wrt);
                wrt.close();
                string = stm.toString();
            }
            catch (Throwable throwable) {
                string = new StringBuilder().append((Object)e.getClass().getName()).append((Object)" (error while printing stack trace)").toString();
            }
        }
        return string;
    }

    public Utils.StringCasts StringCasts(String v) {
        return new Utils.StringCasts(v);
    }

    private Utils$() {
        MODULE$ = this;
        Logger$class.$init$(this);
    }
}

