/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.kubeclient.factory;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import org.apache.flink.kubernetes.kubeclient.FlinkPod;
import org.apache.flink.kubernetes.kubeclient.decorators.CmdTaskManagerDecorator;
import org.apache.flink.kubernetes.kubeclient.decorators.EnvSecretsDecorator;
import org.apache.flink.kubernetes.kubeclient.decorators.FlinkConfMountDecorator;
import org.apache.flink.kubernetes.kubeclient.decorators.HadoopConfMountDecorator;
import org.apache.flink.kubernetes.kubeclient.decorators.InitTaskManagerDecorator;
import org.apache.flink.kubernetes.kubeclient.decorators.KerberosMountDecorator;
import org.apache.flink.kubernetes.kubeclient.decorators.KubernetesStepDecorator;
import org.apache.flink.kubernetes.kubeclient.decorators.MountSecretsDecorator;
import org.apache.flink.kubernetes.kubeclient.parameters.KubernetesTaskManagerParameters;
import org.apache.flink.kubernetes.kubeclient.resources.KubernetesPod;
import org.apache.flink.util.Preconditions;

public class KubernetesTaskManagerFactory {
    public static KubernetesPod buildTaskManagerKubernetesPod(FlinkPod podTemplate, KubernetesTaskManagerParameters kubernetesTaskManagerParameters) {
        KubernetesStepDecorator[] stepDecorators;
        FlinkPod flinkPod = ((FlinkPod)Preconditions.checkNotNull((Object)podTemplate)).copy();
        for (KubernetesStepDecorator stepDecorator : stepDecorators = new KubernetesStepDecorator[]{new InitTaskManagerDecorator(kubernetesTaskManagerParameters), new EnvSecretsDecorator(kubernetesTaskManagerParameters), new MountSecretsDecorator(kubernetesTaskManagerParameters), new CmdTaskManagerDecorator(kubernetesTaskManagerParameters), new HadoopConfMountDecorator(kubernetesTaskManagerParameters), new KerberosMountDecorator(kubernetesTaskManagerParameters), new FlinkConfMountDecorator(kubernetesTaskManagerParameters)}) {
            flinkPod = stepDecorator.decorateFlinkPod(flinkPod);
        }
        Pod resolvedPod = ((PodBuilder)((PodFluent.SpecNested)new PodBuilder(flinkPod.getPodWithoutMainContainer()).editOrNewSpec().addToContainers(flinkPod.getMainContainer())).endSpec()).build();
        return new KubernetesPod(resolvedPod);
    }
}

