/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.runtime.state.InternalPriorityQueue;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyGroupedInternalPriorityQueue;
import org.apache.flink.streaming.api.operators.InternalTimer;
import org.apache.flink.streaming.api.operators.InternalTimerService;
import org.apache.flink.streaming.api.operators.InternalTimersSnapshot;
import org.apache.flink.streaming.api.operators.KeyContext;
import org.apache.flink.streaming.api.operators.TimerHeapInternalTimer;
import org.apache.flink.streaming.api.operators.Triggerable;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.util.CloseableIterator;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.BiConsumerWithException;

public class InternalTimerServiceImpl<K, N>
implements InternalTimerService<N> {
    private final ProcessingTimeService processingTimeService;
    private final KeyContext keyContext;
    private final KeyGroupedInternalPriorityQueue<TimerHeapInternalTimer<K, N>> processingTimeTimersQueue;
    private final KeyGroupedInternalPriorityQueue<TimerHeapInternalTimer<K, N>> eventTimeTimersQueue;
    private final KeyGroupRange localKeyGroupRange;
    private final int localKeyGroupRangeStartIdx;
    private long currentWatermark = Long.MIN_VALUE;
    private ScheduledFuture<?> nextTimer;
    private TypeSerializer<K> keySerializer;
    private TypeSerializer<N> namespaceSerializer;
    private Triggerable<K, N> triggerTarget;
    private volatile boolean isInitialized;
    private TypeSerializer<K> keyDeserializer;
    private TypeSerializer<N> namespaceDeserializer;
    private InternalTimersSnapshot<K, N> restoredTimersSnapshot;

    InternalTimerServiceImpl(KeyGroupRange localKeyGroupRange, KeyContext keyContext, ProcessingTimeService processingTimeService, KeyGroupedInternalPriorityQueue<TimerHeapInternalTimer<K, N>> processingTimeTimersQueue, KeyGroupedInternalPriorityQueue<TimerHeapInternalTimer<K, N>> eventTimeTimersQueue) {
        this.keyContext = (KeyContext)Preconditions.checkNotNull((Object)keyContext);
        this.processingTimeService = (ProcessingTimeService)Preconditions.checkNotNull((Object)processingTimeService);
        this.localKeyGroupRange = (KeyGroupRange)Preconditions.checkNotNull((Object)localKeyGroupRange);
        this.processingTimeTimersQueue = (KeyGroupedInternalPriorityQueue)Preconditions.checkNotNull(processingTimeTimersQueue);
        this.eventTimeTimersQueue = (KeyGroupedInternalPriorityQueue)Preconditions.checkNotNull(eventTimeTimersQueue);
        int startIdx = Integer.MAX_VALUE;
        for (Integer keyGroupIdx : localKeyGroupRange) {
            startIdx = Math.min(keyGroupIdx, startIdx);
        }
        this.localKeyGroupRangeStartIdx = startIdx;
    }

    public void startTimerService(TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer, Triggerable<K, N> triggerTarget) {
        if (!this.isInitialized) {
            if (keySerializer == null || namespaceSerializer == null) {
                throw new IllegalArgumentException("The TimersService serializers cannot be null.");
            }
            if (this.keySerializer != null || this.namespaceSerializer != null || this.triggerTarget != null) {
                throw new IllegalStateException("The TimerService has already been initialized.");
            }
            if (this.restoredTimersSnapshot != null) {
                TypeSerializerSchemaCompatibility keySerializerCompatibility = this.restoredTimersSnapshot.getKeySerializerSnapshot().resolveSchemaCompatibility(keySerializer);
                if (keySerializerCompatibility.isIncompatible() || keySerializerCompatibility.isCompatibleAfterMigration()) {
                    throw new IllegalStateException("Tried to initialize restored TimerService with new key serializer that requires migration or is incompatible.");
                }
                TypeSerializerSchemaCompatibility namespaceSerializerCompatibility = this.restoredTimersSnapshot.getNamespaceSerializerSnapshot().resolveSchemaCompatibility(namespaceSerializer);
                this.restoredTimersSnapshot = null;
                if (namespaceSerializerCompatibility.isIncompatible() || namespaceSerializerCompatibility.isCompatibleAfterMigration()) {
                    throw new IllegalStateException("Tried to initialize restored TimerService with new namespace serializer that requires migration or is incompatible.");
                }
                this.keySerializer = keySerializerCompatibility.isCompatibleAsIs() ? keySerializer : keySerializerCompatibility.getReconfiguredSerializer();
                this.namespaceSerializer = namespaceSerializerCompatibility.isCompatibleAsIs() ? namespaceSerializer : namespaceSerializerCompatibility.getReconfiguredSerializer();
            } else {
                this.keySerializer = keySerializer;
                this.namespaceSerializer = namespaceSerializer;
            }
            this.keyDeserializer = null;
            this.namespaceDeserializer = null;
            this.triggerTarget = (Triggerable)Preconditions.checkNotNull(triggerTarget);
            InternalTimer headTimer = (InternalTimer)this.processingTimeTimersQueue.peek();
            if (headTimer != null) {
                this.nextTimer = this.processingTimeService.registerTimer(headTimer.getTimestamp(), this::onProcessingTime);
            }
            this.isInitialized = true;
        } else if (!this.keySerializer.equals(keySerializer) || !this.namespaceSerializer.equals(namespaceSerializer)) {
            throw new IllegalArgumentException("Already initialized Timer Service tried to be initialized with different key and namespace serializers.");
        }
    }

    @Override
    public long currentProcessingTime() {
        return this.processingTimeService.getCurrentProcessingTime();
    }

    @Override
    public long currentWatermark() {
        return this.currentWatermark;
    }

    @Override
    public void registerProcessingTimeTimer(N namespace, long time) {
        InternalTimer oldHead = (InternalTimer)this.processingTimeTimersQueue.peek();
        if (this.processingTimeTimersQueue.add(new TimerHeapInternalTimer<Object, N>(time, this.keyContext.getCurrentKey(), namespace))) {
            long nextTriggerTime;
            long l = nextTriggerTime = oldHead != null ? oldHead.getTimestamp() : Long.MAX_VALUE;
            if (time < nextTriggerTime) {
                if (this.nextTimer != null) {
                    this.nextTimer.cancel(false);
                }
                this.nextTimer = this.processingTimeService.registerTimer(time, this::onProcessingTime);
            }
        }
    }

    @Override
    public void registerEventTimeTimer(N namespace, long time) {
        this.eventTimeTimersQueue.add(new TimerHeapInternalTimer<Object, N>(time, this.keyContext.getCurrentKey(), namespace));
    }

    @Override
    public void deleteProcessingTimeTimer(N namespace, long time) {
        this.processingTimeTimersQueue.remove(new TimerHeapInternalTimer<Object, N>(time, this.keyContext.getCurrentKey(), namespace));
    }

    @Override
    public void deleteEventTimeTimer(N namespace, long time) {
        this.eventTimeTimersQueue.remove(new TimerHeapInternalTimer<Object, N>(time, this.keyContext.getCurrentKey(), namespace));
    }

    @Override
    public void forEachEventTimeTimer(BiConsumerWithException<N, Long, Exception> consumer) throws Exception {
        this.foreachTimer(consumer, this.eventTimeTimersQueue);
    }

    @Override
    public void forEachProcessingTimeTimer(BiConsumerWithException<N, Long, Exception> consumer) throws Exception {
        this.foreachTimer(consumer, this.processingTimeTimersQueue);
    }

    private void foreachTimer(BiConsumerWithException<N, Long, Exception> consumer, KeyGroupedInternalPriorityQueue<TimerHeapInternalTimer<K, N>> queue) throws Exception {
        try (CloseableIterator iterator = queue.iterator();){
            while (iterator.hasNext()) {
                TimerHeapInternalTimer timer = (TimerHeapInternalTimer)iterator.next();
                this.keyContext.setCurrentKey(timer.getKey());
                consumer.accept(timer.getNamespace(), (Object)timer.getTimestamp());
            }
        }
    }

    private void onProcessingTime(long time) throws Exception {
        InternalTimer timer;
        this.nextTimer = null;
        while ((timer = (InternalTimer)this.processingTimeTimersQueue.peek()) != null && timer.getTimestamp() <= time) {
            this.processingTimeTimersQueue.poll();
            this.keyContext.setCurrentKey(timer.getKey());
            this.triggerTarget.onProcessingTime(timer);
        }
        if (timer != null && this.nextTimer == null) {
            this.nextTimer = this.processingTimeService.registerTimer(timer.getTimestamp(), this::onProcessingTime);
        }
    }

    public void advanceWatermark(long time) throws Exception {
        InternalTimer timer;
        this.currentWatermark = time;
        while ((timer = (InternalTimer)this.eventTimeTimersQueue.peek()) != null && timer.getTimestamp() <= time) {
            this.eventTimeTimersQueue.poll();
            this.keyContext.setCurrentKey(timer.getKey());
            this.triggerTarget.onEventTime(timer);
        }
    }

    public InternalTimersSnapshot<K, N> snapshotTimersForKeyGroup(int keyGroupIdx) {
        return new InternalTimersSnapshot<K, N>(this.keySerializer, this.namespaceSerializer, this.eventTimeTimersQueue.getSubsetForKeyGroup(keyGroupIdx), this.processingTimeTimersQueue.getSubsetForKeyGroup(keyGroupIdx));
    }

    public TypeSerializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    public TypeSerializer<N> getNamespaceSerializer() {
        return this.namespaceSerializer;
    }

    public void restoreTimersForKeyGroup(InternalTimersSnapshot<?, ?> restoredSnapshot, int keyGroupIdx) {
        this.restoredTimersSnapshot = restoredSnapshot;
        TypeSerializer restoredKeySerializer = this.restoredTimersSnapshot.getKeySerializerSnapshot().restoreSerializer();
        if (this.keyDeserializer != null && !this.keyDeserializer.equals((Object)restoredKeySerializer)) {
            throw new IllegalArgumentException("Tried to restore timers for the same service with different key serializers.");
        }
        this.keyDeserializer = restoredKeySerializer;
        TypeSerializer restoredNamespaceSerializer = this.restoredTimersSnapshot.getNamespaceSerializerSnapshot().restoreSerializer();
        if (this.namespaceDeserializer != null && !this.namespaceDeserializer.equals((Object)restoredNamespaceSerializer)) {
            throw new IllegalArgumentException("Tried to restore timers for the same service with different namespace serializers.");
        }
        this.namespaceDeserializer = restoredNamespaceSerializer;
        Preconditions.checkArgument((boolean)this.localKeyGroupRange.contains(keyGroupIdx), (Object)("Key Group " + keyGroupIdx + " does not belong to the local range."));
        this.eventTimeTimersQueue.addAll(this.restoredTimersSnapshot.getEventTimeTimers());
        this.processingTimeTimersQueue.addAll(this.restoredTimersSnapshot.getProcessingTimeTimers());
    }

    @VisibleForTesting
    public int numProcessingTimeTimers() {
        return this.processingTimeTimersQueue.size();
    }

    @VisibleForTesting
    public int numEventTimeTimers() {
        return this.eventTimeTimersQueue.size();
    }

    @VisibleForTesting
    public int numProcessingTimeTimers(N namespace) {
        return this.countTimersInNamespaceInternal(namespace, (InternalPriorityQueue<TimerHeapInternalTimer<K, N>>)this.processingTimeTimersQueue);
    }

    @VisibleForTesting
    public int numEventTimeTimers(N namespace) {
        return this.countTimersInNamespaceInternal(namespace, (InternalPriorityQueue<TimerHeapInternalTimer<K, N>>)this.eventTimeTimersQueue);
    }

    private int countTimersInNamespaceInternal(N namespace, InternalPriorityQueue<TimerHeapInternalTimer<K, N>> queue) {
        int count = 0;
        try (CloseableIterator iterator = queue.iterator();){
            while (iterator.hasNext()) {
                TimerHeapInternalTimer timer = (TimerHeapInternalTimer)iterator.next();
                if (!timer.getNamespace().equals(namespace)) continue;
                ++count;
            }
        }
        catch (Exception e) {
            throw new FlinkRuntimeException("Exception when closing iterator.", (Throwable)e);
        }
        return count;
    }

    @VisibleForTesting
    int getLocalKeyGroupRangeStartIdx() {
        return this.localKeyGroupRangeStartIdx;
    }

    @VisibleForTesting
    List<Set<TimerHeapInternalTimer<K, N>>> getEventTimeTimersPerKeyGroup() {
        return this.partitionElementsByKeyGroup(this.eventTimeTimersQueue);
    }

    @VisibleForTesting
    List<Set<TimerHeapInternalTimer<K, N>>> getProcessingTimeTimersPerKeyGroup() {
        return this.partitionElementsByKeyGroup(this.processingTimeTimersQueue);
    }

    private <T> List<Set<T>> partitionElementsByKeyGroup(KeyGroupedInternalPriorityQueue<T> keyGroupedQueue) {
        ArrayList<Set<T>> result = new ArrayList<Set<T>>(this.localKeyGroupRange.getNumberOfKeyGroups());
        Iterator iterator = this.localKeyGroupRange.iterator();
        while (iterator.hasNext()) {
            int keyGroup = (Integer)iterator.next();
            result.add(Collections.unmodifiableSet(keyGroupedQueue.getSubsetForKeyGroup(keyGroup)));
        }
        return result;
    }
}

