/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.dk.brics.automaton;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.flink.kubernetes.shaded.dk.brics.automaton.Automaton;
import org.apache.flink.kubernetes.shaded.dk.brics.automaton.BasicOperations;
import org.apache.flink.kubernetes.shaded.dk.brics.automaton.State;
import org.apache.flink.kubernetes.shaded.dk.brics.automaton.StatePair;
import org.apache.flink.kubernetes.shaded.dk.brics.automaton.Transition;
import org.apache.flink.kubernetes.shaded.dk.brics.automaton.TransitionComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ShuffleOperations {
    private ShuffleOperations() {
    }

    public static Automaton shuffle(Automaton automaton, Automaton automaton2) {
        State state;
        automaton.determinize();
        automaton2.determinize();
        Transition[][] transitionArray = Automaton.getSortedTransitions(automaton.getStates());
        Transition[][] transitionArray2 = Automaton.getSortedTransitions(automaton2.getStates());
        Automaton automaton3 = new Automaton();
        LinkedList<StatePair> linkedList = new LinkedList<StatePair>();
        HashMap<StatePair, StatePair> hashMap = new HashMap<StatePair, StatePair>();
        automaton3.initial = state = new State();
        StatePair statePair = new StatePair(state, automaton.initial, automaton2.initial);
        linkedList.add(statePair);
        hashMap.put(statePair, statePair);
        while (linkedList.size() > 0) {
            StatePair statePair2;
            statePair = (StatePair)linkedList.removeFirst();
            statePair.s.accept = statePair.s1.accept && statePair.s2.accept;
            Transition[] transitionArray3 = transitionArray[statePair.s1.number];
            for (int i = 0; i < transitionArray3.length; ++i) {
                StatePair statePair3 = new StatePair(transitionArray3[i].to, statePair.s2);
                statePair2 = (StatePair)hashMap.get(statePair3);
                if (statePair2 == null) {
                    statePair3.s = new State();
                    linkedList.add(statePair3);
                    hashMap.put(statePair3, statePair3);
                    statePair2 = statePair3;
                }
                statePair.s.transitions.add(new Transition(transitionArray3[i].min, transitionArray3[i].max, statePair2.s));
            }
            Transition[] transitionArray4 = transitionArray2[statePair.s2.number];
            for (int i = 0; i < transitionArray4.length; ++i) {
                statePair2 = new StatePair(statePair.s1, transitionArray4[i].to);
                StatePair statePair4 = (StatePair)hashMap.get(statePair2);
                if (statePair4 == null) {
                    statePair2.s = new State();
                    linkedList.add(statePair2);
                    hashMap.put(statePair2, statePair2);
                    statePair4 = statePair2;
                }
                statePair.s.transitions.add(new Transition(transitionArray4[i].min, transitionArray4[i].max, statePair4.s));
            }
        }
        automaton3.deterministic = false;
        automaton3.removeDeadTransitions();
        automaton3.checkMinimizeAlways();
        return automaton3;
    }

    public static String shuffleSubsetOf(Collection<Automaton> collection, Automaton automaton, Character c, Character c2) {
        Serializable serializable2;
        Transition[][][] transitionArrayArray;
        if (collection.size() == 0) {
            return null;
        }
        if (collection.size() == 1) {
            transitionArrayArray = collection.iterator().next();
            if (transitionArrayArray.isSingleton()) {
                if (automaton.run(transitionArrayArray.singleton)) {
                    return null;
                }
                return transitionArrayArray.singleton;
            }
            if (transitionArrayArray == automaton) {
                return null;
            }
        }
        automaton.determinize();
        transitionArrayArray = new Transition[collection.size()][][];
        int n = 0;
        for (Serializable serializable2 : collection) {
            transitionArrayArray[n++] = Automaton.getSortedTransitions(serializable2.getStates());
        }
        Transition[][] transitionArray = Automaton.getSortedTransitions(automaton.getStates());
        serializable2 = new TransitionComparator(false);
        ShuffleConfiguration shuffleConfiguration = new ShuffleConfiguration(collection, automaton);
        LinkedList<ShuffleConfiguration> linkedList = new LinkedList<ShuffleConfiguration>();
        HashSet<ShuffleConfiguration> hashSet = new HashSet<ShuffleConfiguration>();
        linkedList.add(shuffleConfiguration);
        hashSet.add(shuffleConfiguration);
        block1: while (!linkedList.isEmpty()) {
            ShuffleConfiguration shuffleConfiguration2 = (ShuffleConfiguration)linkedList.removeFirst();
            boolean bl = true;
            for (int i = 0; i < collection.size(); ++i) {
                if (shuffleConfiguration2.ca_states[i].accept) continue;
                bl = false;
                break;
            }
            if (shuffleConfiguration2.a_state.accept) {
                bl = false;
            }
            if (bl) {
                StringBuilder stringBuilder = new StringBuilder();
                while (shuffleConfiguration2.prev != null) {
                    stringBuilder.append(shuffleConfiguration2.min);
                    shuffleConfiguration2 = shuffleConfiguration2.prev;
                }
                StringBuilder stringBuilder2 = new StringBuilder();
                for (int i = stringBuilder.length() - 1; i >= 0; --i) {
                    stringBuilder2.append(stringBuilder.charAt(i));
                }
                return stringBuilder2.toString();
            }
            Transition[] transitionArray2 = transitionArray[shuffleConfiguration2.a_state.number];
            for (int i = 0; i < collection.size(); ++i) {
                if (shuffleConfiguration2.shuffle_suspended) {
                    i = shuffleConfiguration2.suspended1;
                }
                block6: for (Transition transition : transitionArrayArray[i][shuffleConfiguration2.ca_states[i].number]) {
                    int n2;
                    char c3;
                    Transition[] transitionArray3;
                    ArrayList<Transition> arrayList = new ArrayList<Transition>();
                    int n3 = Arrays.binarySearch(transitionArray2, transition, serializable2);
                    if (n3 < 0) {
                        n3 = -n3 - 1;
                    }
                    if (n3 > 0 && transitionArray2[n3 - 1].max >= transition.min) {
                        --n3;
                    }
                    while (n3 < transitionArray2.length) {
                        transitionArray3 = transitionArray2[n3++];
                        c3 = transition.min;
                        n2 = transition.max;
                        if (transitionArray3.min > c3) {
                            c3 = transitionArray3.min;
                        }
                        if (transitionArray3.max < n2) {
                            n2 = transitionArray3.max;
                        }
                        if (c3 > n2) break;
                        ShuffleOperations.add(c, c2, linkedList, hashSet, shuffleConfiguration2, i, transition, (Transition)transitionArray3, c3, (char)n2);
                        arrayList.add(new Transition(c3, (char)n2, null));
                    }
                    transitionArray3 = arrayList.toArray(new Transition[arrayList.size()]);
                    Arrays.sort(transitionArray3, serializable2);
                    c3 = transition.min;
                    for (n2 = 0; n2 < transitionArray3.length && transitionArray3[n2].min <= c3; ++n2) {
                        if (transitionArray3[n2].max >= transition.max) continue block6;
                        c3 = (char)(transitionArray3[n2].max + '\u0001');
                    }
                    ShuffleConfiguration shuffleConfiguration3 = new ShuffleConfiguration(shuffleConfiguration2, i, transition.to, c3);
                    StringBuilder stringBuilder = new StringBuilder();
                    ShuffleConfiguration shuffleConfiguration4 = shuffleConfiguration3;
                    while (shuffleConfiguration4.prev != null) {
                        stringBuilder.append(shuffleConfiguration4.min);
                        shuffleConfiguration4 = shuffleConfiguration4.prev;
                    }
                    StringBuilder stringBuilder3 = new StringBuilder();
                    for (int j = stringBuilder.length() - 1; j >= 0; --j) {
                        stringBuilder3.append(stringBuilder.charAt(j));
                    }
                    if (shuffleConfiguration2.shuffle_suspended) {
                        stringBuilder3.append(BasicOperations.getShortestExample(shuffleConfiguration3.ca_states[shuffleConfiguration2.suspended1], true));
                    }
                    for (i = 0; i < collection.size(); ++i) {
                        if (shuffleConfiguration2.shuffle_suspended && i == shuffleConfiguration2.suspended1) continue;
                        stringBuilder3.append(BasicOperations.getShortestExample(shuffleConfiguration3.ca_states[i], true));
                    }
                    return stringBuilder3.toString();
                }
                if (shuffleConfiguration2.shuffle_suspended) continue block1;
            }
        }
        return null;
    }

    private static void add(Character c, Character c2, LinkedList<ShuffleConfiguration> linkedList, Set<ShuffleConfiguration> set, ShuffleConfiguration shuffleConfiguration, int n, Transition transition, Transition transition2, char c3, char c4) {
        if (c != null && c3 <= c.charValue() && c.charValue() <= c4 && c3 != c4) {
            if (c3 < c.charValue()) {
                ShuffleOperations.add(c, c2, linkedList, set, shuffleConfiguration, n, transition, transition2, c3, (char)(c.charValue() - '\u0001'));
            }
            ShuffleOperations.add(c, c2, linkedList, set, shuffleConfiguration, n, transition, transition2, c.charValue(), c.charValue());
            if (c.charValue() < c4) {
                ShuffleOperations.add(c, c2, linkedList, set, shuffleConfiguration, n, transition, transition2, (char)(c.charValue() + '\u0001'), c4);
            }
        } else if (c2 != null && c3 <= c2.charValue() && c2.charValue() <= c4 && c3 != c4) {
            if (c3 < c2.charValue()) {
                ShuffleOperations.add(c, c2, linkedList, set, shuffleConfiguration, n, transition, transition2, c3, (char)(c2.charValue() - '\u0001'));
            }
            ShuffleOperations.add(c, c2, linkedList, set, shuffleConfiguration, n, transition, transition2, c2.charValue(), c2.charValue());
            if (c2.charValue() < c4) {
                ShuffleOperations.add(c, c2, linkedList, set, shuffleConfiguration, n, transition, transition2, (char)(c2.charValue() + '\u0001'), c4);
            }
        } else if (c3 < '\ud800' && c4 >= '\ud800') {
            ShuffleOperations.add(c, c2, linkedList, set, shuffleConfiguration, n, transition, transition2, c3, '\ud7ff');
            ShuffleOperations.add(c, c2, linkedList, set, shuffleConfiguration, n, transition, transition2, '\ud800', c4);
        } else if (c3 <= '\udbff' && c4 > '\udbff') {
            ShuffleOperations.add(c, c2, linkedList, set, shuffleConfiguration, n, transition, transition2, c3, '\udbff');
            ShuffleOperations.add(c, c2, linkedList, set, shuffleConfiguration, n, transition, transition2, '\udc00', c4);
        } else {
            ShuffleConfiguration shuffleConfiguration2 = new ShuffleConfiguration(shuffleConfiguration, n, transition.to, transition2.to, c3);
            if (c != null && c3 == c.charValue()) {
                shuffleConfiguration2.shuffle_suspended = true;
                shuffleConfiguration2.suspended1 = n;
            } else if (c2 != null && c3 == c2.charValue()) {
                shuffleConfiguration2.shuffle_suspended = false;
            }
            if (c3 >= '\ud800' && c3 <= '\ud800') {
                shuffleConfiguration2.shuffle_suspended = true;
                shuffleConfiguration2.suspended1 = n;
                shuffleConfiguration2.surrogate = true;
            }
            if (!set.contains(shuffleConfiguration2)) {
                linkedList.add(shuffleConfiguration2);
                set.add(shuffleConfiguration2);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ShuffleConfiguration {
        ShuffleConfiguration prev;
        State[] ca_states;
        State a_state;
        char min;
        int hash;
        boolean shuffle_suspended;
        boolean surrogate;
        int suspended1;

        private ShuffleConfiguration() {
        }

        ShuffleConfiguration(Collection<Automaton> collection, Automaton automaton) {
            this.ca_states = new State[collection.size()];
            int n = 0;
            for (Automaton automaton2 : collection) {
                this.ca_states[n++] = automaton2.getInitialState();
            }
            this.a_state = automaton.getInitialState();
            this.computeHash();
        }

        ShuffleConfiguration(ShuffleConfiguration shuffleConfiguration, int n, State state, char c) {
            this.prev = shuffleConfiguration;
            this.ca_states = (State[])shuffleConfiguration.ca_states.clone();
            this.a_state = shuffleConfiguration.a_state;
            this.ca_states[n] = state;
            this.min = c;
            this.computeHash();
        }

        ShuffleConfiguration(ShuffleConfiguration shuffleConfiguration, int n, State state, State state2, char c) {
            this.prev = shuffleConfiguration;
            this.ca_states = (State[])shuffleConfiguration.ca_states.clone();
            this.a_state = shuffleConfiguration.a_state;
            this.ca_states[n] = state;
            this.a_state = state2;
            this.min = c;
            if (!this.surrogate) {
                this.shuffle_suspended = shuffleConfiguration.shuffle_suspended;
                this.suspended1 = shuffleConfiguration.suspended1;
            }
            this.computeHash();
        }

        public boolean equals(Object object) {
            if (object instanceof ShuffleConfiguration) {
                ShuffleConfiguration shuffleConfiguration = (ShuffleConfiguration)object;
                return this.shuffle_suspended == shuffleConfiguration.shuffle_suspended && this.surrogate == shuffleConfiguration.surrogate && this.suspended1 == shuffleConfiguration.suspended1 && Arrays.equals(this.ca_states, shuffleConfiguration.ca_states) && this.a_state == shuffleConfiguration.a_state;
            }
            return false;
        }

        public int hashCode() {
            return this.hash;
        }

        private void computeHash() {
            this.hash = 0;
            for (int i = 0; i < this.ca_states.length; ++i) {
                this.hash ^= this.ca_states[i].hashCode();
            }
            this.hash ^= this.a_state.hashCode() * 100;
            if (this.shuffle_suspended || this.surrogate) {
                this.hash += this.suspended1;
            }
        }
    }
}

