/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators;

import java.util.Arrays;
import org.apache.flink.annotation.Public;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.functions.GroupCombineFunction;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.operators.Keys;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.operators.Ordering;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.Utils;
import org.apache.flink.api.java.functions.FirstReducer;
import org.apache.flink.api.java.operators.GroupCombineOperator;
import org.apache.flink.api.java.operators.GroupReduceOperator;
import org.apache.flink.api.java.operators.Grouping;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.util.Preconditions;

@Public
public class SortedGrouping<T>
extends Grouping<T> {
    private int[] groupSortKeyPositions;
    private Order[] groupSortOrders;
    private Keys.SelectorFunctionKeys<T, ?> groupSortSelectorFunctionKey = null;

    public SortedGrouping(DataSet<T> set, Keys<T> keys, int field, Order order) {
        super(set, keys);
        if (!Keys.ExpressionKeys.isSortKey((int)field, this.inputDataSet.getType())) {
            throw new InvalidProgramException("Selected sort key is not a sortable type");
        }
        Keys.ExpressionKeys ek = new Keys.ExpressionKeys(field, this.inputDataSet.getType());
        this.groupSortKeyPositions = ek.computeLogicalKeyPositions();
        this.groupSortOrders = new Order[this.groupSortKeyPositions.length];
        Arrays.fill(this.groupSortOrders, order);
    }

    public SortedGrouping(DataSet<T> set, Keys<T> keys, String field, Order order) {
        super(set, keys);
        if (!Keys.ExpressionKeys.isSortKey((String)field, this.inputDataSet.getType())) {
            throw new InvalidProgramException("Selected sort key is not a sortable type");
        }
        Keys.ExpressionKeys ek = new Keys.ExpressionKeys(field, this.inputDataSet.getType());
        this.groupSortKeyPositions = ek.computeLogicalKeyPositions();
        this.groupSortOrders = new Order[this.groupSortKeyPositions.length];
        Arrays.fill(this.groupSortOrders, order);
    }

    public <K> SortedGrouping(DataSet<T> set, Keys<T> keys, Keys.SelectorFunctionKeys<T, K> keySelector, Order order) {
        super(set, keys);
        if (!(this.keys instanceof Keys.SelectorFunctionKeys)) {
            throw new InvalidProgramException("Sorting on KeySelector keys only works with KeySelector grouping.");
        }
        TypeInformation sortKeyType = keySelector.getKeyType();
        if (!sortKeyType.isSortKeyType()) {
            throw new InvalidProgramException("Key type " + sortKeyType + " is not sortable.");
        }
        this.groupSortKeyPositions = keySelector.computeLogicalKeyPositions();
        int i = 0;
        while (i < this.groupSortKeyPositions.length) {
            int n = i++;
            this.groupSortKeyPositions[n] = this.groupSortKeyPositions[n] + this.keys.getNumberOfKeyFields();
        }
        this.groupSortSelectorFunctionKey = keySelector;
        this.groupSortOrders = new Order[this.groupSortKeyPositions.length];
        Arrays.fill(this.groupSortOrders, order);
    }

    protected int[] getGroupSortKeyPositions() {
        return this.groupSortKeyPositions;
    }

    protected Order[] getGroupSortOrders() {
        return this.groupSortOrders;
    }

    protected Ordering getGroupOrdering() {
        Ordering o = new Ordering();
        for (int i = 0; i < this.groupSortKeyPositions.length; ++i) {
            o.appendOrdering(Integer.valueOf(this.groupSortKeyPositions[i]), null, this.groupSortOrders[i]);
        }
        return o;
    }

    public SortedGrouping<T> withPartitioner(Partitioner<?> partitioner) {
        Preconditions.checkNotNull(partitioner);
        this.getKeys().validateCustomPartitioner(partitioner, null);
        this.customPartitioner = partitioner;
        return this;
    }

    protected Keys.SelectorFunctionKeys<T, ?> getSortSelectionFunctionKey() {
        return this.groupSortSelectorFunctionKey;
    }

    public <R> GroupReduceOperator<T, R> reduceGroup(GroupReduceFunction<T, R> reducer) {
        if (reducer == null) {
            throw new NullPointerException("GroupReduce function must not be null.");
        }
        TypeInformation resultType = TypeExtractor.getGroupReduceReturnTypes(reducer, this.inputDataSet.getType(), (String)Utils.getCallLocationName(), (boolean)true);
        return new GroupReduceOperator<T, R>(this, resultType, this.inputDataSet.clean(reducer), Utils.getCallLocationName());
    }

    public <R> GroupCombineOperator<T, R> combineGroup(GroupCombineFunction<T, R> combiner) {
        if (combiner == null) {
            throw new NullPointerException("GroupCombine function must not be null.");
        }
        TypeInformation resultType = TypeExtractor.getGroupCombineReturnTypes(combiner, this.getInputDataSet().getType(), (String)Utils.getCallLocationName(), (boolean)true);
        return new GroupCombineOperator<T, R>(this, resultType, this.inputDataSet.clean(combiner), Utils.getCallLocationName());
    }

    public GroupReduceOperator<T, T> first(int n) {
        if (n < 1) {
            throw new InvalidProgramException("Parameter n of first(n) must be at least 1.");
        }
        return this.reduceGroup(new FirstReducer(n));
    }

    public SortedGrouping<T> sortGroup(int field, Order order) {
        if (this.groupSortSelectorFunctionKey != null) {
            throw new InvalidProgramException("Chaining sortGroup with KeySelector sorting is not supported");
        }
        if (!Keys.ExpressionKeys.isSortKey((int)field, this.inputDataSet.getType())) {
            throw new InvalidProgramException("Selected sort key is not a sortable type");
        }
        Keys.ExpressionKeys ek = new Keys.ExpressionKeys(field, this.inputDataSet.getType());
        this.addSortGroupInternal(ek, order);
        return this;
    }

    public SortedGrouping<T> sortGroup(String field, Order order) {
        if (this.groupSortSelectorFunctionKey != null) {
            throw new InvalidProgramException("Chaining sortGroup with KeySelector sorting is not supported");
        }
        if (!Keys.ExpressionKeys.isSortKey((String)field, this.inputDataSet.getType())) {
            throw new InvalidProgramException("Selected sort key is not a sortable type");
        }
        Keys.ExpressionKeys ek = new Keys.ExpressionKeys(field, this.inputDataSet.getType());
        this.addSortGroupInternal(ek, order);
        return this;
    }

    private void addSortGroupInternal(Keys.ExpressionKeys<T> ek, Order order) {
        Preconditions.checkArgument((order != null ? 1 : 0) != 0, (Object)"Order can not be null");
        int[] additionalKeyPositions = ek.computeLogicalKeyPositions();
        int newLength = this.groupSortKeyPositions.length + additionalKeyPositions.length;
        this.groupSortKeyPositions = Arrays.copyOf(this.groupSortKeyPositions, newLength);
        this.groupSortOrders = Arrays.copyOf(this.groupSortOrders, newLength);
        int off = newLength - additionalKeyPositions.length;
        for (int pos = newLength - additionalKeyPositions.length; pos < newLength; ++pos) {
            this.groupSortKeyPositions[pos] = additionalKeyPositions[pos - off];
            this.groupSortOrders[pos] = order;
        }
    }
}

